/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.engine.IDiffEngine;
import org.eclipse.emf.compare.diff.service.DiffEngineDescriptor;
import org.eclipse.emf.compare.util.ModelIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffEngineRegistry
extends HashMap<String, List<Object>> {
    public static final DiffEngineRegistry INSTANCE = new DiffEngineRegistry();
    private static final String DIFF_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.diff.engine";
    private static final String SEPARATOR = ",";
    private static final long serialVersionUID = 2237008034183610765L;
    private static final String TAG_ENGINE = "diffengine";
    private static final String WILDCARD = "*";
    private final List<DiffEngineDescriptor> nsPatternDescriptors = new ArrayList<DiffEngineDescriptor>();

    private DiffEngineRegistry() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.parseExtensionMetadata();
        } else {
            this.putValue(WILDCARD, new GenericDiffEngine());
        }
    }

    public List<DiffEngineDescriptor> getDescriptors(ModelIdentifier identifier) {
        List<Object> candidates = this.getEnginesForIdentifier(identifier);
        candidates.addAll((Collection)this.get(WILDCARD));
        ArrayList<DiffEngineDescriptor> engines = new ArrayList<DiffEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof DiffEngineDescriptor)) continue;
            engines.add((DiffEngineDescriptor)value);
        }
        return engines;
    }

    @Deprecated
    public List<DiffEngineDescriptor> getDescriptors(String engineIdentifier) {
        List specific = (List)this.get(engineIdentifier);
        ArrayList candidates = new ArrayList((Collection)this.get(WILDCARD));
        if (specific != null) {
            candidates.addAll(0, specific);
        }
        ArrayList<DiffEngineDescriptor> engines = new ArrayList<DiffEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof DiffEngineDescriptor)) continue;
            engines.add((DiffEngineDescriptor)value);
        }
        return engines;
    }

    public IDiffEngine getHighestEngine(ModelIdentifier identifier) {
        IDiffEngine highest = null;
        List<Object> engines = this.getEnginesForIdentifier(identifier);
        if (engines.size() != 0) {
            highest = this.getSpecificHighestEngine(engines);
        }
        if (highest == null) {
            highest = this.getSpecificHighestEngine((List)this.get(WILDCARD));
        }
        return highest;
    }

    @Deprecated
    public IDiffEngine getHighestEngine(String engineIdentifier) {
        List engines = (List)this.get(engineIdentifier);
        IDiffEngine highest = null;
        if (engines != null) {
            highest = this.getSpecificHighestEngine(engines);
        }
        if (highest == null) {
            highest = this.getSpecificHighestEngine((List)this.get(WILDCARD));
        }
        return highest;
    }

    public void putValue(String key, Object value) {
        if (value instanceof IDiffEngine || value instanceof DiffEngineDescriptor) {
            ArrayList<Object> values = (ArrayList<Object>)this.get(key);
            if (values != null) {
                values.add(value);
            } else {
                values = new ArrayList<Object>();
                values.add(value);
                super.put(key, values);
            }
        } else {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("DiffEngineRegistry.IllegalEngine", value.getClass().getName()));
        }
    }

    private List<Object> getEnginesForIdentifier(ModelIdentifier identifier) {
        List newCandidates;
        ArrayList<Object> candidates = new ArrayList<Object>();
        if (identifier.getNamespace() != null) {
            newCandidates = (List)this.get(identifier.getNamespace());
            if (newCandidates != null) {
                candidates.addAll(newCandidates);
            }
            for (DiffEngineDescriptor desc : this.nsPatternDescriptors) {
                if (!identifier.getNamespace().matches(desc.getNamespacePattern())) continue;
                candidates.add(desc);
            }
        }
        if (identifier.getContentType() != null && (newCandidates = (List)this.get(identifier.getContentType())) != null) {
            candidates.addAll(newCandidates);
        }
        if (identifier.getExtension() != null && (newCandidates = (List)this.get(identifier.getExtension())) != null) {
            candidates.addAll(newCandidates);
        }
        return candidates;
    }

    private IDiffEngine getSpecificHighestEngine(List<Object> engines) {
        int highestPriority = -1;
        IDiffEngine highest = null;
        for (Object engine : engines) {
            if (engine instanceof DiffEngineDescriptor) {
                DiffEngineDescriptor desc = (DiffEngineDescriptor)engine;
                if (desc.getPriorityValue() <= highestPriority) continue;
                highest = desc.getEngineInstance();
                highestPriority = desc.getPriorityValue();
                continue;
            }
            if (!(engine instanceof IDiffEngine)) continue;
            highest = (IDiffEngine)engine;
        }
        return highest;
    }

    private DiffEngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        DiffEngineDescriptor desc = new DiffEngineDescriptor(configElement);
        return desc;
    }

    private void parseExtensionMetadata() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(DIFF_ENGINES_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String[] fileExtensions;
                String[] contentTypes;
                String[] namespaces;
                DiffEngineDescriptor desc = this.parseEngine(configElements[j]);
                String namespacePattern = desc.getNamespacePattern();
                if (!"".equals(namespacePattern)) {
                    this.nsPatternDescriptors.add(desc);
                }
                String[] stringArray = namespaces = desc.getNamespace().split(SEPARATOR);
                int n = namespaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String ns = stringArray[n2];
                    if (!"".equals(ns)) {
                        this.putValue(ns, desc);
                    }
                    ++n2;
                }
                String[] stringArray2 = contentTypes = desc.getContentType().split(SEPARATOR);
                int n3 = contentTypes.length;
                n = 0;
                while (n < n3) {
                    String ct = stringArray2[n];
                    if (!"".equals(ct)) {
                        this.putValue(ct, desc);
                    }
                    ++n;
                }
                String[] stringArray3 = fileExtensions = desc.getFileExtension().split(SEPARATOR);
                int n4 = fileExtensions.length;
                n3 = 0;
                while (n3 < n4) {
                    String ext = stringArray3[n3];
                    if (!"".equals(ext)) {
                        this.putValue(ext, desc);
                    }
                    ++n3;
                }
                ++j;
            }
            ++i;
        }
    }
}

