/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaDirectiveAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseSelectionAction;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTFileStoreEditorInput;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTReadOnlyFileEditorInput;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDFileEditorInput;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDImportImpl;

public class OpenInNewEditor
extends BaseSelectionAction {
    public static final String ID = "OpenInNewEditor";
    static /* synthetic */ Class class$0;

    public OpenInNewEditor(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_OPEN_IN_NEW_EDITOR);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        IEditorPart activeEditor;
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        IEditorInput editorInput = null;
        if (workbenchWindow != null && (activeEditor = (page = workbenchWindow.getActivePage()).getActiveEditor()) != null) {
            editorInput = activeEditor.getEditorInput();
        }
        if (selection instanceof XSDBaseAdapter) {
            XSDSchema xsdSchema;
            XSDBaseAdapter xsdAdapter = (XSDBaseAdapter)selection;
            XSDConcreteComponent fComponent = (XSDConcreteComponent)xsdAdapter.getTarget();
            XSDSchema schema = fComponent.getSchema();
            boolean isReference = false;
            if (fComponent instanceof XSDFeature) {
                isReference = ((XSDFeature)fComponent).isFeatureReference();
                fComponent = ((XSDFeature)fComponent).getResolvedFeature();
            }
            String schemaLocation = null;
            Path schemaPath = null;
            IFile schemaFile = null;
            if (selection instanceof XSDSchemaDirectiveAdapter) {
                XSDSchemaDirective dir = (XSDSchemaDirective)((XSDSchemaDirectiveAdapter)selection).getTarget();
                if (dir instanceof XSDImportImpl) {
                    ((XSDImportImpl)dir).importSchema();
                }
                if (dir.getResolvedSchema() != null) {
                    schemaLocation = URIHelper.removePlatformResourceProtocol((String)dir.getResolvedSchema().getSchemaLocation());
                    schemaPath = new Path(schemaLocation);
                    schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
                    schema = dir.getResolvedSchema();
                    fComponent = dir.getResolvedSchema();
                }
            } else if (fComponent.getSchema() != null && fComponent.eContainer() instanceof XSDSchema || isReference) {
                schemaLocation = URIHelper.removePlatformResourceProtocol((String)fComponent.getSchema().getSchemaLocation());
                schemaPath = new Path(schemaLocation);
                schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
                try {
                    IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    xsdSchema = (XSDSchema)iWorkbenchPart.getAdapter((Class)clazz);
                    if (fComponent.getSchema() == xsdSchema) {
                        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (editorPart instanceof InternalXSDMultiPageEditor) {
                            ((InternalXSDMultiPageEditor)editorPart).openOnGlobalReference(fComponent);
                        }
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            if (page != null && schemaFile != null && schemaFile.exists()) {
                try {
                    IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    xsdSchema = (XSDSchema)iWorkbenchPart.getAdapter((Class)clazz);
                    IEditorPart editorPart = null;
                    if (xsdSchema != null && fComponent.getRootContainer().eResource() == xsdSchema.eResource() && xsdSchema != schema) {
                        String editorName = null;
                        XSDFileEditorInput xsdFileEditorInput = new XSDFileEditorInput(schemaFile, fComponent.getSchema());
                        if (editorInput != null) {
                            editorName = editorInput.getName();
                            xsdFileEditorInput.setEditorName(editorName);
                        }
                        if ((editorPart = this.getExistingEditorForInlineSchema(page, schemaFile, schema)) == null) {
                            editorPart = page.openEditor((IEditorInput)xsdFileEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                        }
                    } else {
                        editorPart = page.openEditor((IEditorInput)new FileEditorInput(schemaFile), "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                    }
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        ((InternalXSDMultiPageEditor)editorPart).openOnGlobalReference(fComponent);
                    }
                }
                catch (Exception exception) {}
            } else if (schemaLocation != null) {
                OpenInNewEditor.openExternalFiles(page, schemaLocation, fComponent);
            }
        }
    }

    public static void openXSDEditor(IEditorInput editorInput, XSDConcreteComponent xsdComponent) {
        OpenInNewEditor.openXSDEditor(editorInput, xsdComponent.getSchema(), xsdComponent);
    }

    public static void openXSDEditor(IEditorInput editorInput, XSDSchema schema, XSDConcreteComponent xsdComponent) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        String resource = schema.getSchemaLocation();
        if (editorInput instanceof FileEditorInput && resource != null && !resource.startsWith("http")) {
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)resource);
            OpenInNewEditor.openWorkspaceFile(page, schemaLocation, xsdComponent);
        } else {
            OpenInNewEditor.openExternalFiles(page, resource, xsdComponent);
        }
    }

    public static void openInlineSchema(IEditorInput editorInput, XSDConcreteComponent xsdComponent, XSDSchema schema, String editorName) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        boolean isWorkspaceFile = false;
        String schemaLocation = schema.getSchemaLocation();
        String workspaceFileLocation = URIHelper.removePlatformResourceProtocol((String)schemaLocation);
        Path workspaceFilePath = new Path(workspaceFileLocation);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspaceFilePath);
        if (page != null && file != null && file.exists()) {
            isWorkspaceFile = true;
        }
        if (isWorkspaceFile) {
            try {
                IEditorPart editorPart = null;
                XSDFileEditorInput xsdFileEditorInput = new XSDFileEditorInput(file, schema);
                xsdFileEditorInput.setEditorName(editorName);
                IEditorReference[] refs = page.getEditorReferences();
                int length = refs.length;
                int i = 0;
                while (i < length) {
                    IFile aFile;
                    IEditorInput input = refs[i].getEditorInput();
                    if (input instanceof XSDFileEditorInput && (aFile = ((XSDFileEditorInput)input).getFile()).getFullPath().equals((Object)file.getFullPath()) && ((XSDFileEditorInput)input).getSchema() == schema) {
                        editorPart = refs[i].getEditor(true);
                        page.activate(refs[i].getPart(true));
                        break;
                    }
                    ++i;
                }
                if (editorPart == null) {
                    editorPart = page.openEditor((IEditorInput)xsdFileEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                }
                if (editorPart instanceof InternalXSDMultiPageEditor) {
                    InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                    xsdEditor.openOnGlobalReference(xsdComponent);
                }
            }
            catch (PartInitException partInitException) {}
        } else {
            if (schemaLocation != null && !schemaLocation.startsWith("http")) {
                String fileLocation = null;
                fileLocation = File.separatorChar == '/' ? "/" + URIHelper.removePlatformResourceProtocol((String)schemaLocation) : URIHelper.removeProtocol((String)schemaLocation);
                Path schemaPath = new Path(fileLocation);
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)schemaPath);
                if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    try {
                        ADTFileStoreEditorInput xsdFileStoreEditorInput = new ADTFileStoreEditorInput(fileStore, schema);
                        xsdFileStoreEditorInput.setEditorName(editorName);
                        IEditorPart editorPart = null;
                        IEditorReference[] refs = page.getEditorReferences();
                        int length = refs.length;
                        int i = 0;
                        while (i < length) {
                            URI uri;
                            IEditorInput input = refs[i].getEditorInput();
                            if (input instanceof ADTFileStoreEditorInput && (uri = ((ADTFileStoreEditorInput)input).getURI()).equals(xsdFileStoreEditorInput.getURI()) && ((ADTFileStoreEditorInput)input).getSchema() == xsdFileStoreEditorInput.getSchema()) {
                                editorPart = refs[i].getEditor(true);
                                page.activate(refs[i].getPart(true));
                                break;
                            }
                            ++i;
                        }
                        if (page != null && editorPart == null) {
                            editorPart = page.openEditor((IEditorInput)xsdFileStoreEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                        }
                        if (editorPart instanceof InternalXSDMultiPageEditor) {
                            InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                            xsdEditor.openOnGlobalReference(xsdComponent);
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
            } else {
                try {
                    IEditorPart editorPart = null;
                    IEditorReference[] refs = page.getEditorReferences();
                    int length = refs.length;
                    int i = 0;
                    while (i < length) {
                        ADTReadOnlyFileEditorInput xsdFileStorageEditorInput;
                        IEditorInput input = refs[i].getEditorInput();
                        if (input instanceof ADTReadOnlyFileEditorInput && (xsdFileStorageEditorInput = (ADTReadOnlyFileEditorInput)input).getUrlString().equals(schemaLocation) && xsdFileStorageEditorInput.getEditorID().equals("org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor")) {
                            editorPart = refs[i].getEditor(true);
                            page.activate(refs[i].getPart(true));
                            break;
                        }
                        ++i;
                    }
                    if (editorPart == null) {
                        ADTReadOnlyFileEditorInput xsdFileStorageEditorInput = new ADTReadOnlyFileEditorInput(schemaLocation);
                        xsdFileStorageEditorInput.setSchema(schema);
                        xsdFileStorageEditorInput.setEditorName(editorName);
                        xsdFileStorageEditorInput.setEditorID("org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                        editorPart = page.openEditor((IEditorInput)xsdFileStorageEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                    }
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                        xsdEditor.openOnGlobalReference(xsdComponent);
                    }
                }
                catch (PartInitException partInitException) {}
            }
            return;
        }
    }

    private IEditorPart getExistingEditorForInlineSchema(IWorkbenchPage page, IFile schemaFile, XSDSchema schema) {
        IEditorReference[] refs = page.getEditorReferences();
        int length = refs.length;
        IEditorPart editorPart = null;
        try {
            int i = 0;
            while (i < length) {
                IFile aFile;
                IEditorInput input = refs[i].getEditorInput();
                if (input instanceof XSDFileEditorInput && (aFile = ((XSDFileEditorInput)input).getFile()).getFullPath().equals((Object)schemaFile.getFullPath()) && ((XSDFileEditorInput)input).getSchema() == schema) {
                    editorPart = refs[i].getEditor(true);
                    page.activate(refs[i].getPart(true));
                    break;
                }
                ++i;
            }
        }
        catch (PartInitException partInitException) {}
        return editorPart;
    }

    public static void openWorkspaceFile(IWorkbenchPage page, String schemaLocation, XSDConcreteComponent xsdComponent) {
        Path schemaPath = new Path(schemaLocation);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
        if (page != null && file != null && file.exists()) {
            try {
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                if (editorPart instanceof InternalXSDMultiPageEditor) {
                    InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                    xsdEditor.openOnGlobalReference(xsdComponent);
                }
            }
            catch (PartInitException partInitException) {}
        }
    }

    public static void openExternalFiles(IWorkbenchPage page, String schemaLocation, XSDConcreteComponent fComponent) {
        block19: {
            if (schemaLocation == null) {
                return;
            }
            Path schemaPath = new Path(schemaLocation);
            if (!schemaLocation.startsWith("http")) {
                schemaPath = new Path(URIHelper.removeProtocol((String)schemaLocation));
            }
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)schemaPath);
            URI schemaURI = URI.create(schemaLocation);
            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                try {
                    IEditorPart editorPart = null;
                    IEditorReference[] refs = page.getEditorReferences();
                    int length = refs.length;
                    int i = 0;
                    while (i < length) {
                        URI uri;
                        IEditorInput input = refs[i].getEditorInput();
                        if (input instanceof FileStoreEditorInput && (uri = ((FileStoreEditorInput)input).getURI()).equals(schemaURI)) {
                            editorPart = refs[i].getEditor(true);
                            page.activate(refs[i].getPart(true));
                            break;
                        }
                        ++i;
                    }
                    if (editorPart == null) {
                        editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                        xsdEditor.openOnGlobalReference(fComponent);
                    }
                }
                catch (PartInitException partInitException) {}
            } else {
                try {
                    if (schemaLocation.startsWith("http")) {
                        try {
                            IEditorPart editorPart = null;
                            IEditorReference[] refs = page.getEditorReferences();
                            int length = refs.length;
                            int i = 0;
                            while (i < length) {
                                ADTReadOnlyFileEditorInput readOnlyEditorInput;
                                IEditorInput input = refs[i].getEditorInput();
                                if (input instanceof ADTReadOnlyFileEditorInput && (readOnlyEditorInput = (ADTReadOnlyFileEditorInput)input).getUrlString().equals(schemaLocation) && "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor".equals(readOnlyEditorInput.getEditorID())) {
                                    editorPart = refs[i].getEditor(true);
                                    page.activate(refs[i].getPart(true));
                                    break;
                                }
                                ++i;
                            }
                            if (editorPart == null) {
                                ADTReadOnlyFileEditorInput readOnlyStorageEditorInput = new ADTReadOnlyFileEditorInput(schemaLocation);
                                readOnlyStorageEditorInput.setEditorID("org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                                editorPart = page.openEditor((IEditorInput)readOnlyStorageEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                            }
                            if (editorPart instanceof InternalXSDMultiPageEditor) {
                                InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                                xsdEditor.openOnGlobalReference(fComponent);
                            }
                            break block19;
                        }
                        catch (PartInitException partInitException) {}
                        break block19;
                    }
                    FileStoreEditorInput xsdFileStoreEditorInput = new FileStoreEditorInput(fileStore);
                    page.openEditor((IEditorInput)xsdFileStoreEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                }
                catch (PartInitException partInitException) {}
            }
        }
    }
}

