/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.connections.CenteredConnectionAnchor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BindingColumnEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BoxComponentFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ComponentReferenceConnection;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingColumnLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingContentLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class BindingEditPart
extends BaseEditPart {
    protected ComponentReferenceConnection connectionFigure;
    private ComponentReferenceConnection connectionFeedbackFigure;
    protected BoxComponentFigure figure;
    protected boolean isExpanded = false;
    private Label hoverHelpLabel = new Label("");

    protected IFigure createFigure() {
        this.figure = new BoxComponentFigure();
        this.figure.getLabel().setBorder((Border)new MarginBorder(2, 2, 1, 2));
        this.figure.setBorder((Border)new LineBorder(0));
        this.figure.getContentPane().setLayoutManager((LayoutManager)new BindingContentLayout(this));
        this.figure.getContentPane().setOpaque(true);
        this.figure.getContentPane().setBackgroundColor(ColorConstants.yellow);
        this.figure.setLayoutManager((LayoutManager)new BindingLayout(this));
        return this.figure;
    }

    public IFigure getContentPane() {
        return this.figure.getContentPane();
    }

    protected List getModelChildren() {
        IBinding binding = (IBinding)this.getModel();
        return this.isExpanded ? binding.getBindingContentList() : Collections.EMPTY_LIST;
    }

    public void activate() {
        super.activate();
        this.activateConnection();
    }

    public void deactivate() {
        super.deactivate();
        this.deactivateConnection();
    }

    public void addFeedback() {
        super.addFeedback();
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.figure.setSelected(true);
        this.figure.repaint();
        if (this.connectionFigure != null && this.connectionFigure.isVisible()) {
            this.connectionFigure.setHighlight(true);
            this.addConnectionFeedbackFigure();
        }
    }

    public void removeFeedback() {
        super.removeFeedback();
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(DesignViewGraphicsConstants.defaultForegroundColor);
        this.figure.setSelected(false);
        this.figure.repaint();
        this.removeConnectionFeedbackFigure();
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(false);
        }
    }

    protected void activateConnection() {
        if (this.createConnectionFigure() != null) {
            this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
        }
    }

    protected void deactivateConnection() {
        if (this.connectionFigure != null) {
            this.getLayer("Connection Layer").remove((IFigure)this.connectionFigure);
        }
        this.removeConnectionFeedbackFigure();
    }

    public ComponentReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        IBinding binding;
        IInterface typeBeingRef;
        if (this.connectionFigure == null && this.shouldDrawConnection() && (typeBeingRef = (binding = (IBinding)this.getModel()).getInterface()) != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null) {
            this.connectionFigure = new ComponentReferenceConnection();
            this.refreshConnections();
        }
        return this.connectionFigure;
    }

    protected boolean shouldDrawConnection() {
        AbstractGraphicalEditPart referenceTypePart;
        if (this.isExpanded) {
            return false;
        }
        IBinding binding = (IBinding)this.getModel();
        IInterface typeBeingRef = binding.getInterface();
        return typeBeingRef != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null;
    }

    protected void refreshVisuals() {
        this.refreshConnections();
        if (this.getModel() instanceof IBinding) {
            IBinding binding = (IBinding)this.getModel();
            ((BoxComponentFigure)this.getFigure()).headingFigure.setIsReadOnly(((IBinding)this.getModel()).isReadOnly());
            if (binding instanceof ITreeElement) {
                this.figure.getLabel().setIcon(((ITreeElement)((Object)binding)).getImage());
            }
            String prependString = Messages._UI_LABEL_BINDING;
            this.hoverHelpLabel.setText(" " + prependString + " : " + binding.getName() + " ");
            this.figure.setToolTip((IFigure)this.hoverHelpLabel);
        }
        super.refreshVisuals();
    }

    protected AbstractGraphicalEditPart getConnectionTargetEditPart() {
        IBinding binding = (IBinding)this.getModel();
        IInterface typeBeingRef = binding.getInterface();
        if (this.connectionFigure != null) {
            AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
            return referenceTypePart;
        }
        return null;
    }

    public void refreshConnections() {
        if (this.shouldDrawConnection()) {
            IBinding binding = (IBinding)this.getModel();
            IInterface typeBeingRef = binding.getInterface();
            if (this.connectionFigure != null) {
                AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
                IFigure refFigure = referenceTypePart.getFigure();
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 3, 0));
                this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(refFigure, 4, 0, 11));
                this.connectionFigure.setHighlight(false);
                this.connectionFigure.setVisible(true);
                if (this.connectionFeedbackFigure != null) {
                    this.addConnectionFeedbackFigure();
                }
            } else {
                this.activateConnection();
            }
        } else if (this.connectionFigure != null) {
            this.connectionFigure.setVisible(false);
            this.removeConnectionFeedbackFigure();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void performRequest(Request request) {
        LayoutManager layoutManager;
        if (request.getType() == "open" && (layoutManager = this.getFigure().getParent().getLayoutManager()) instanceof BindingColumnLayout) {
            BindingColumnLayout bindingColumnLayout = (BindingColumnLayout)layoutManager;
            bindingColumnLayout.setExpanded(this, !this.isExpanded);
            ((BindingColumnEditPart)this.getParent()).refreshBindingEditParts();
        }
    }

    public EditPart getRelativeEditPart(int direction) {
        if (direction == 16) {
            return this.getConnectionTargetEditPart();
        }
        if (direction == 8) {
            return EditPartNavigationHandlerUtil.getSourceConnectionEditPart(this);
        }
        return super.getRelativeEditPart(direction);
    }

    private void addConnectionFeedbackFigure() {
        this.removeConnectionFeedbackFigure();
        this.connectionFeedbackFigure = new ComponentReferenceConnection();
        this.connectionFeedbackFigure.setSourceAnchor(this.connectionFigure.getSourceAnchor());
        this.connectionFeedbackFigure.setTargetAnchor(this.connectionFigure.getTargetAnchor());
        this.connectionFeedbackFigure.setHighlight(true);
        this.getLayer("Feedback Layer").add((IFigure)this.connectionFeedbackFigure);
    }

    private void removeConnectionFeedbackFigure() {
        if (this.connectionFeedbackFigure != null) {
            this.connectionFeedbackFigure.setHighlight(false);
            this.getLayer("Feedback Layer").remove((IFigure)this.connectionFeedbackFigure);
            this.connectionFeedbackFigure = null;
        }
    }
}

