/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.property.GetMultiPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.view.property.PropertyKeywordEditPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SetKeywordsAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        SetKeywordsAction.doSetKeywords(this.getSelectedResources(IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES));
    }

    public static void doSetKeywords(final IResource[] resources) {
        if (!SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "keywords.computeValues")) {
            SetKeywordsAction.askUser(resources, new IResourceProvider(){

                public IResource[] getResources() {
                    return resources;
                }
            }, null);
        } else {
            CompositeOperation composite = new CompositeOperation("Operation_SetKeywordsProperty", SVNUIMessages.class);
            final GetMultiPropertiesOperation getKeywordsOp = new GetMultiPropertiesOperation(resources, 2, IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES, "svn:keywords");
            composite.add((IActionOperation)getKeywordsOp);
            composite.add((IActionOperation)new AbstractActionOperation(composite.getId(), composite.getMessagesClass()){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    if (!monitor.isCanceled()) {
                        SetKeywordsAction.askUser(resources, (IResourceProvider)getKeywordsOp, (IPropertyProvider)getKeywordsOp);
                    }
                }
            });
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
        }
    }

    protected static void askUser(IResource[] resources, IResourceProvider resourceProvider, IPropertyProvider propertyProvider) {
        final PropertyKeywordEditPanel panel = new PropertyKeywordEditPanel(resources, resourceProvider, propertyProvider);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                if (dialog.open() == 0) {
                    panel.performKeywordChanges();
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES);
    }
}

