/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.SVNPostCommitError;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.ShowPostCommitErrorsDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ShowPostCommitErrorsOperation
extends AbstractActionOperation {
    protected IPostCommitErrorsProvider provider;

    public ShowPostCommitErrorsOperation(IPostCommitErrorsProvider provider) {
        super("Operation_ShowPostCommitErrors", SVNUIMessages.class);
        this.provider = provider;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNPostCommitError[] errors = this.provider.getPostCommitErrors();
        if (errors != null) {
            String tCompleteMessage = null;
            SVNPostCommitError[] sVNPostCommitErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                SVNPostCommitError error = sVNPostCommitErrorArray[n2];
                tCompleteMessage = tCompleteMessage == null ? error.message : String.valueOf(tCompleteMessage) + "\n\n" + error.message;
                ++n2;
            }
            if (tCompleteMessage != null) {
                final String completeMessage = tCompleteMessage;
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        new ShowPostCommitErrorsDialog(UIMonitorUtility.getShell(), completeMessage).open();
                    }
                });
            }
        }
    }
}

