/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorUtils {
    public View deduceViewContainer(View source, View target) {
        List<View> sourceProposedContainers = this.getStructureContainers(source);
        List<View> targetProposedContainers = this.getStructureContainers(target);
        View deducedContainer = null;
        for (View container : sourceProposedContainers) {
            if (!targetProposedContainers.contains(container)) continue;
            deducedContainer = container;
            break;
        }
        return deducedContainer;
    }

    public Property getPartWithPort(View checkedView, View oppositeView) {
        View parentView;
        EObject semanticParent;
        Property result = null;
        EObject targetPort = checkedView.getElement();
        if (targetPort instanceof Port && (semanticParent = (parentView = ViewUtil.getContainerView((View)checkedView)).getElement()) instanceof Property && !(semanticParent instanceof Port) && !EcoreUtil.isAncestor((EObject)parentView, (EObject)oppositeView)) {
            result = (Property)semanticParent;
        }
        return result;
    }

    public StructuredClassifier deduceContainer(View source, View target) {
        return this.deduceViewContainer(source, target) != null ? this.getStructuredClassifier(this.deduceViewContainer(source, target)) : null;
    }

    public List<View> getStructureContainers(View view) {
        ArrayList<View> containerViews = new ArrayList<View>();
        View currentView = view;
        while (currentView != null) {
            if (currentView instanceof Shape && this.getStructuredClassifier(currentView) != null) {
                containerViews.add(currentView);
            }
            currentView = ViewUtil.getContainerView((View)currentView);
        }
        return containerViews;
    }

    public StructuredClassifier getStructuredClassifier(View view) {
        Property property;
        StructuredClassifier structuredClassifier = null;
        EObject semanticElement = view.getElement();
        if (semanticElement instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)semanticElement;
        } else if (semanticElement instanceof Property && (property = (Property)semanticElement).getType() != null && property.getType() instanceof StructuredClassifier) {
            structuredClassifier = (StructuredClassifier)property.getType();
        }
        return structuredClassifier;
    }

    public ConnectorEnd getSourceConnectorEnd(Connector connector) {
        return (ConnectorEnd)connector.getEnds().get(0);
    }

    public ConnectorEnd getTargetConnectorEnd(Connector connector) {
        return (ConnectorEnd)connector.getEnds().get(1);
    }
}

