/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.RelaunchActionDelegate;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TerminateAndRelaunchAction
extends DebugCommandAction {
    static /* synthetic */ Class class$0;

    public void postExecute(IRequest request, final Object[] targets) {
        if (request.getStatus() == null || request.getStatus().isOK()) {
            DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < targets.length) {
                        ILaunch launch = DebugUIPlugin.getLaunch(targets[i]);
                        if (launch != null) {
                            RelaunchActionDelegate.relaunch(launch.getLaunchConfiguration(), launch.getLaunchMode());
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected ISelection getContext() {
        ISelection context = super.getContext();
        if (context instanceof IStructuredSelection && !context.isEmpty()) {
            IStructuredSelection ss = (IStructuredSelection)context;
            HashSet<ILaunch> launches = new HashSet<ILaunch>(ss.size());
            Iterator itr = ss.iterator();
            while (itr.hasNext()) {
                ILaunch launch = DebugUIPlugin.getLaunch(itr.next());
                if (launch == null) continue;
                launches.add(launch);
            }
            return new StructuredSelection(launches.toArray());
        }
        return super.getContext();
    }

    protected Class getCommandType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.commands.ITerminateHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection context = event.getContext();
        if (context instanceof IStructuredSelection) {
            Object[] elements = ((IStructuredSelection)context).toArray();
            int i = 0;
            while (i < elements.length) {
                if (!this.canRelaunch(elements[i])) {
                    this.setEnabled(false);
                    return;
                }
                ++i;
            }
        }
        super.debugContextChanged(event);
    }

    protected boolean canRelaunch(Object element) {
        ILaunchConfiguration configuration;
        ILaunch launch = DebugUIPlugin.getLaunch(element);
        if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
            return LaunchConfigurationManager.isVisible(configuration);
        }
        return false;
    }

    public String getActionDefinitionId() {
        return ActionMessages.TerminateAndRelaunchAction_0;
    }

    public String getHelpContextId() {
        return "org.eclipse.debug.ui.terminate_and_relaunch_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.TerminateAndRelaunch";
    }

    public String getText() {
        return ActionMessages.TerminateAndRelaunchAction_3;
    }

    public String getToolTipText() {
        return ActionMessages.TerminateAndRelaunchAction_4;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }
}

