/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.impl.CachedList;
import org.eclipse.emf.cdo.security.impl.SecurityElementImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmImpl
extends SecurityElementImpl
implements Realm {
    private EList<User> allUsers = new CachedList<User>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_USERS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allUsers(items).toArray();
        }
    };
    private EList<Group> allGroups = new CachedList<Group>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_GROUPS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allGroups(items).toArray();
        }
    };
    private EList<Role> allRoles = new CachedList<Role>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_ROLES;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allRoles(items).toArray();
        }
    };
    private EList<Permission> allPermissions = new CachedList<Permission>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_PERMISSIONS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allPermissions(items).toArray();
        }
    };

    protected RealmImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.REALM;
    }

    @Override
    public EList<SecurityItem> getItems() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__ITEMS, true);
    }

    @Override
    public EList<User> getAllUsers() {
        return this.allUsers;
    }

    @Override
    public EList<Group> getAllGroups() {
        return this.allGroups;
    }

    @Override
    public EList<Role> getAllRoles() {
        return this.allRoles;
    }

    @Override
    public EList<Permission> getAllPermissions() {
        return this.allPermissions;
    }

    @Override
    public String getName() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__NAME, true);
    }

    @Override
    public void setName(String newName) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__NAME, newName);
    }

    @Override
    public Access getDefaultAccess() {
        return (Access)((Object)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ACCESS, true));
    }

    @Override
    public void setDefaultAccess(Access newDefaultAccess) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ACCESS, (Object)newDefaultAccess);
    }

    @Override
    public Directory getDefaultUserDirectory() {
        return (Directory)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_USER_DIRECTORY, true);
    }

    @Override
    public void setDefaultUserDirectory(Directory newDefaultUserDirectory) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_USER_DIRECTORY, newDefaultUserDirectory);
    }

    @Override
    public Directory getDefaultGroupDirectory() {
        return (Directory)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_GROUP_DIRECTORY, true);
    }

    @Override
    public void setDefaultGroupDirectory(Directory newDefaultGroupDirectory) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_GROUP_DIRECTORY, newDefaultGroupDirectory);
    }

    @Override
    public Directory getDefaultRoleDirectory() {
        return (Directory)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ROLE_DIRECTORY, true);
    }

    @Override
    public void setDefaultRoleDirectory(Directory newDefaultRoleDirectory) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ROLE_DIRECTORY, newDefaultRoleDirectory);
    }

    @Override
    public Role getRole(String id) {
        return RealmUtil.findRole(this.getItems(), id);
    }

    @Override
    public Group getGroup(String id) {
        return RealmUtil.findGroup(this.getItems(), id);
    }

    @Override
    public User getUser(String id) {
        return RealmUtil.findUser(this.getItems(), id);
    }

    protected EList<SecurityItem> getRoleItems() {
        Directory directory = this.getDefaultRoleDirectory();
        return directory != null ? directory.getItems() : this.getItems();
    }

    protected EList<SecurityItem> getGroupItems() {
        Directory directory = this.getDefaultGroupDirectory();
        return directory != null ? directory.getItems() : this.getItems();
    }

    protected EList<SecurityItem> getUserItems() {
        Directory directory = this.getDefaultUserDirectory();
        return directory != null ? directory.getItems() : this.getItems();
    }

    @Override
    public Role addRole(String id) {
        Role role = SecurityFactory.eINSTANCE.createRole(id);
        EList<SecurityItem> items = this.getRoleItems();
        items.add((Object)role);
        return role;
    }

    @Override
    public Group addGroup(String id) {
        Group group = SecurityFactory.eINSTANCE.createGroup(id);
        EList<SecurityItem> items = this.getGroupItems();
        items.add((Object)group);
        return group;
    }

    @Override
    public User addUser(String id) {
        User user = SecurityFactory.eINSTANCE.createUser(id);
        return this.addUser(user);
    }

    @Override
    public User addUser(String id, String password) {
        User user = SecurityFactory.eINSTANCE.createUser(id, password);
        return this.addUser(user);
    }

    protected User addUser(User user) {
        EList<SecurityItem> items = this.getUserItems();
        items.add((Object)user);
        return user;
    }

    @Override
    public Role removeRole(String id) {
        EList<SecurityItem> realmItems;
        EList<SecurityItem> items = this.getRoleItems();
        Role role = RealmUtil.removeRole(items, id);
        if (role == null && items != (realmItems = this.getItems())) {
            role = RealmUtil.removeRole(realmItems, id);
        }
        return role;
    }

    @Override
    public Group removeGroup(String id) {
        EList<SecurityItem> realmItems;
        EList<SecurityItem> items = this.getGroupItems();
        Group group = RealmUtil.removeGroup(items, id);
        if (group == null && items != (realmItems = this.getItems())) {
            group = RealmUtil.removeGroup(realmItems, id);
        }
        return group;
    }

    @Override
    public User removeUser(String id) {
        EList<SecurityItem> realmItems;
        EList<SecurityItem> items = this.getUserItems();
        User user = RealmUtil.removeUser(items, id);
        if (user == null && items != (realmItems = this.getItems())) {
            user = RealmUtil.removeUser(realmItems, id);
        }
        return user;
    }

    @Override
    public Realm getRealm() {
        return this;
    }
}

