/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ExportOperation
extends AbstractWorkingCopyOperation {
    protected SVNRevision revision;
    protected String path;
    protected boolean ignoreExternals;

    public ExportOperation(IResource[] resources, String path, SVNRevision revision, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, resources);
        this.revision = revision;
        this.path = path;
        this.ignoreExternals = ignoreExternals;
    }

    public ExportOperation(IResourceProvider provider, String path, SVNRevision revision, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, provider);
        this.revision = revision;
        this.path = path;
        this.ignoreExternals = ignoreExternals;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            final IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    String wcPath = FileUtility.getWorkingCopyPath(current);
                    String targetPath = String.valueOf(ExportOperation.this.path) + "/" + current.getName();
                    ExportOperation.this.writeToConsole(0, "svn export \"" + wcPath + "\" -r " + ExportOperation.this.revision.toString() + SVNUtility.getIgnoreExternalsArg(ExportOperation.this.ignoreExternals) + " \"" + FileUtility.normalizePath(targetPath) + "\" --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                    long options = 4L;
                    if (ExportOperation.this.ignoreExternals) {
                        options |= 1L;
                    }
                    proxy.doExport(new SVNEntryRevisionReference(wcPath, null, ExportOperation.this.revision), targetPath, null, 3, options, new SVNProgressMonitor(ExportOperation.this, monitor, null));
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{FileUtility.getNamesListAsString(this.operableData())});
    }
}

