/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class RemovePropertiesOperation
extends AbstractWorkingCopyOperation {
    protected SVNProperty[] data;
    protected boolean isRecursive;

    public RemovePropertiesOperation(IResource[] resources, SVNProperty[] data, boolean isRecursive) {
        super("Operation_RemoveProperties", SVNMessages.class, resources);
        this.data = data;
        this.isRecursive = isRecursive;
    }

    public RemovePropertiesOperation(IResourceProvider resourceProvider, SVNProperty[] data, boolean isRecursive) {
        super("Operation_RemoveProperties", SVNMessages.class, resourceProvider);
        this.data = data;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource resource = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    RemovePropertiesOperation.this.processResource(proxy, resource, monitor);
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected void processResource(final ISVNConnector proxy, IResource resource, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, resource.getFullPath().toString());
        final String wcPath = FileUtility.getWorkingCopyPath(resource);
        int i = 0;
        while (i < this.data.length && !monitor.isCanceled()) {
            final SVNProperty current = this.data[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.removeProperty(new String[]{wcPath}, current.name, RemovePropertiesOperation.this.isRecursive ? 3 : 0, 0L, null, new SVNProgressMonitor(RemovePropertiesOperation.this, monitor, null));
                }
            }, monitor, this.data.length);
            ++i;
        }
    }
}

