/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.repositories.core.RepositoryCategory;

public class RepositoryCategoryContentProvider
implements ITreeContentProvider {
    private static final Map<String, RepositoryCategory> repositoryCategories = new HashMap<String, RepositoryCategory>();

    public RepositoryCategoryContentProvider() {
        ExtensionPointReader.initExtensions();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return repositoryCategories.values().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    static class ExtensionPointReader {
        public static final String EXTENSION_CUSTOM_CATEGORY = "org.eclipse.mylyn.commons.repositories.ui.categories";
        public static final String EXTENSION_TMPL_REPOSITORY_CATEGORY = "category";
        private static final String ELEMENT_REPOSITORY_CATEGORY_ID = "id";
        private static final String ELEMENT_REPOSITORY_CATEGORY_LABEL = "label";
        private static final String ELEMENT_REPOSITORY_CATEGORY_RANK = "rank";

        ExtensionPointReader() {
        }

        public static void initExtensions() {
            IExtension[] templateExtensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_CUSTOM_CATEGORY);
            IExtension[] iExtensionArray = templateExtensions = templatesExtensionPoint.getExtensions();
            int n = templateExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension templateExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = templateExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(EXTENSION_TMPL_REPOSITORY_CATEGORY)) {
                        ExtensionPointReader.readRepositoryCategory(element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private static void readRepositoryCategory(IConfigurationElement element) {
            int rankInt;
            String id = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_ID);
            String label = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_LABEL);
            String rank = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_RANK);
            try {
                rankInt = Integer.parseInt(rank);
            }
            catch (NumberFormatException numberFormatException) {
                rankInt = 0;
            }
            RepositoryCategory cat = new RepositoryCategory(id, label, rankInt);
            repositoryCategories.put(cat.getId(), cat);
        }
    }
}

