/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class PartDropHelper
extends ElementHelper {
    public PartDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropPartOnPart(DropObjectsRequest request, GraphicalEditPart host) {
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidPart(droppedEObject, this.getHostEObject(host))) {
            return UnexecutableCommand.INSTANCE;
        }
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new SemanticAdapter((EObject)droppedEObject, null), Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        return viewCreateCommand;
    }

    private boolean isValidPart(Object object, EObject dropTarget) {
        boolean isValid = false;
        if (object != null && object instanceof Property && !(object instanceof Port) && dropTarget != null && dropTarget instanceof TypedElement && ((TypedElement)dropTarget).getType() != null) {
            Type targetType = ((TypedElement)dropTarget).getType();
            if (((Property)object).eContainer() == targetType) {
                isValid = true;
            }
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

