/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.osgi.framework.Bundle;

public final class CDOPackageTypeRegistry {
    public static final CDOPackageTypeRegistry INSTANCE = new CDOPackageTypeRegistry();
    private static final String ECORE_ID = "org.eclipse.emf.ecore";
    private static final String PPID = "generated_package";
    private static final String MARKER_FILE = "META-INF/CDO.MF";
    private Map<String, CDOPackageUnit.Type> types = new HashMap<String, CDOPackageUnit.Type>();
    private Map<String, CDOPackageUnit.Type> bundles = new HashMap<String, CDOPackageUnit.Type>();

    private CDOPackageTypeRegistry() {
    }

    public synchronized CDOPackageUnit.Type register(EPackage ePackage) {
        CDOPackageUnit.Type type = CDOPackageTypeRegistry.getPackageType(ePackage);
        this.types.put(ePackage.getNsURI(), type);
        return type;
    }

    public synchronized void registerNative(String packageURI) {
        this.types.put(packageURI, CDOPackageUnit.Type.NATIVE);
    }

    public synchronized void registerLegacy(String packageURI) {
        this.types.put(packageURI, CDOPackageUnit.Type.LEGACY);
    }

    public synchronized void registerDynamic(String packageURI) {
        this.types.put(packageURI, CDOPackageUnit.Type.DYNAMIC);
    }

    public synchronized CDOPackageUnit.Type deregister(String packageURI) {
        return this.types.remove(packageURI);
    }

    public synchronized CDOPackageUnit.Type lookup(String packageURI) {
        CDOPackageUnit.Type type = this.types.get(packageURI);
        if (type == null) {
            Object value = EPackage.Registry.INSTANCE.get((Object)packageURI);
            if (value instanceof EPackage) {
                EPackage ePackage = (EPackage)value;
                type = this.register(ePackage);
            }
            if (type == null && OMPlatform.INSTANCE.isExtensionRegistryAvailable()) {
                type = this.getTypeFromBundle(packageURI);
                this.types.put(packageURI, type);
            }
        }
        return type;
    }

    public synchronized CDOPackageUnit.Type lookup(EPackage ePackage) {
        String packageURI = ePackage.getNsURI();
        CDOPackageUnit.Type type = this.types.get(packageURI);
        if (type == null) {
            type = this.register(ePackage);
        }
        return type;
    }

    public synchronized void reset() {
        this.types.clear();
        this.bundles.clear();
    }

    private CDOPackageUnit.Type getTypeFromBundle(String packageURI) {
        String bundleID = CDOPackageTypeRegistry.getBundleID(packageURI);
        if (bundleID == null) {
            return CDOPackageUnit.Type.UNKNOWN;
        }
        CDOPackageUnit.Type type = this.bundles.get(bundleID);
        if (type == null) {
            Bundle bundle = Platform.getBundle((String)bundleID);
            type = bundle == null ? CDOPackageUnit.Type.UNKNOWN : (bundle.getEntry(MARKER_FILE) != null ? CDOPackageUnit.Type.NATIVE : CDOPackageUnit.Type.LEGACY);
            this.bundles.put(bundleID, type);
        }
        return type;
    }

    private static String getBundleID(String packageURI) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(ECORE_ID, PPID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String uri = element.getAttribute("uri");
            if (ObjectUtil.equals((Object)uri, (Object)packageURI)) {
                return element.getContributor().getName();
            }
            ++n2;
        }
        return null;
    }

    private static CDOPackageUnit.Type getPackageType(EPackage ePackage) {
        if (ePackage.getClass() == EPackageImpl.class) {
            return CDOPackageUnit.Type.DYNAMIC;
        }
        EPackage topLevelPackage = EMFUtil.getTopLevelPackage(ePackage);
        EClass eClass = CDOPackageTypeRegistry.getAnyConcreteEClass(topLevelPackage);
        if (eClass != null) {
            EObject testObject = EcoreUtil.create((EClass)eClass);
            if (testObject instanceof CDOObjectMarker) {
                return CDOPackageUnit.Type.NATIVE;
            }
            return CDOPackageUnit.Type.LEGACY;
        }
        return null;
    }

    private static EClass getAnyConcreteEClass(EPackage ePackage) {
        EClass eClass;
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass) || (eClass = (EClass)classifier).isAbstract() || eClass.isInterface()) continue;
            return eClass;
        }
        for (EPackage subpackage : ePackage.getESubpackages()) {
            eClass = CDOPackageTypeRegistry.getAnyConcreteEClass(subpackage);
            if (eClass == null) continue;
            return eClass;
        }
        return null;
    }

    public static interface CDOObjectMarker {
    }
}

