/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.internal.efs.AbstractFileStore;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOResourceNodeStore;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceStore;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceNodeStore
extends AbstractFileStore {
    private CDOID resourceNodeID;

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return (String[])new ResourceNodeRunnable<String[]>(){

            @Override
            protected String[] run(CDOResourceNode node) {
                ArrayList<String> childNames = new ArrayList<String>();
                AbstractResourceNodeStore.this.collectChildNames(node, childNames);
                return childNames.toArray(new String[childNames.size()]);
            }
        }.run();
    }

    public IFileStore getChild(String name) {
        return new CDOResourceNodeStore(this.getWorkspaceStore(), this, name);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return (IFileInfo)new ResourceNodeRunnable<IFileInfo>(){

            @Override
            protected IFileInfo run(CDOResourceNode node) {
                boolean directory;
                long lastModified = 0L;
                boolean exists = node != null;
                boolean bl = directory = exists && AbstractResourceNodeStore.this.isDirectory(node);
                if (!directory) {
                    lastModified = AbstractResourceNodeStore.this.getWorkspaceStore().getLastModified(AbstractResourceNodeStore.this.getPath());
                }
                FileInfo info = new FileInfo(AbstractResourceNodeStore.this.getName());
                info.setLastModified(lastModified);
                info.setExists(exists);
                info.setDirectory(directory);
                info.setLength(0L);
                info.setAttribute(2, false);
                info.setAttribute(16, false);
                return info;
            }
        }.run();
    }

    public abstract CDOWorkspaceStore getWorkspaceStore();

    public abstract AbstractResourceNodeStore getParent();

    public abstract String getPath();

    protected CDOView getView() {
        return this.getWorkspaceStore().getView();
    }

    protected abstract CDOResourceNode getResourceNode(CDOView var1);

    protected abstract boolean isDirectory(CDOResourceNode var1);

    protected abstract void collectChildNames(CDOResourceNode var1, List<String> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ResourceNodeRunnable<RESULT> {
        public RESULT run() {
            return this.run(false);
        }

        public RESULT run(boolean transactional) {
            CDOView view = null;
            try {
                view = this.openView(transactional);
                RESULT result = this.run(view);
                if (transactional) {
                    CDOTransaction transaction = (CDOTransaction)view;
                    transaction.commit();
                }
                RESULT RESULT = result;
                return RESULT;
            }
            catch (CommitException ex) {
                throw WrappedException.wrap((Exception)((Object)ex));
            }
            finally {
                if (transactional) {
                    IOUtil.close((Closeable)view);
                }
            }
        }

        protected RESULT run(CDOView view) {
            CDOResourceNode node = this.getResourceNode(view);
            RESULT result = this.run(node);
            return result;
        }

        protected RESULT run(CDOResourceNode node) {
            return null;
        }

        private CDOView openView(boolean transactional) {
            CDOWorkspace workspace = AbstractResourceNodeStore.this.getWorkspaceStore().getWorkspace();
            return transactional ? workspace.openTransaction() : AbstractResourceNodeStore.this.getView();
        }

        private CDOResourceNode getResourceNode(CDOView view) {
            CDOResourceNode node = null;
            try {
                if (AbstractResourceNodeStore.this.resourceNodeID == null) {
                    node = AbstractResourceNodeStore.this.getResourceNode(view);
                    AbstractResourceNodeStore.this.resourceNodeID = node.cdoID();
                } else {
                    node = (CDOResourceNode)view.getObject(AbstractResourceNodeStore.this.resourceNodeID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return node;
        }
    }
}

