/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.environment.CompositeWidgetType;
import org.eclipse.papyrus.views.properties.environment.Environment;
import org.eclipse.papyrus.views.properties.environment.EnvironmentPackage;
import org.eclipse.papyrus.views.properties.environment.LayoutType;
import org.eclipse.papyrus.views.properties.environment.Namespace;
import org.eclipse.papyrus.views.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.views.properties.environment.StandardWidgetType;
import org.eclipse.papyrus.views.properties.environment.Type;
import org.eclipse.papyrus.views.properties.environment.WidgetType;
import org.eclipse.papyrus.views.properties.extensions.ContextExtensionPoint;
import org.eclipse.papyrus.views.properties.extensions.EnvironmentExtensionPoint;
import org.eclipse.papyrus.views.properties.root.PropertiesRoot;
import org.eclipse.papyrus.views.properties.root.RootFactory;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationConflict;
import org.eclipse.papyrus.views.properties.runtime.PreferencesMigrator;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngine;
import org.eclipse.papyrus.views.properties.runtime.ViewConstraintEngineImpl;
import org.eclipse.papyrus.views.properties.runtime.preferences.ContextDescriptor;
import org.eclipse.papyrus.views.properties.runtime.preferences.Preferences;
import org.eclipse.papyrus.views.properties.runtime.preferences.PreferencesFactory;
import org.eclipse.papyrus.views.properties.runtime.preferences.PreferencesPackage;
import org.eclipse.papyrus.views.properties.storage.ContextStorageRegistry;
import org.eclipse.papyrus.views.properties.storage.IContextStorageProvider;
import org.eclipse.papyrus.views.properties.storage.IContextStorageProviderListener;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    private final Preferences preferences;
    private final PropertiesRoot root;
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private boolean started = false;
    private final Map<URI, Context> contexts;
    private final Set<Context> enabledContexts;
    private final Map<Context, Boolean> customizableContexts;
    private final ContextStorageRegistry contextStorageRegistry;
    private IContextStorageProviderListener contextStorageProviderListener;
    public ViewConstraintEngine constraintEngine = new ViewConstraintEngineImpl();
    public static final ConfigurationManager instance = new ConfigurationManager();

    private ConfigurationManager() {
        this.enabledContexts = new LinkedHashSet<Context>();
        this.customizableContexts = new HashMap<Context, Boolean>();
        this.contexts = new LinkedHashMap<URI, Context>();
        this.contextStorageRegistry = new ContextStorageRegistry(this.resourceSet);
        this.root = RootFactory.eINSTANCE.createPropertiesRoot();
        this.preferences = this.loadPreferences();
    }

    private void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new ContextExtensionPoint();
        new EnvironmentExtensionPoint();
        this.loadCustomContexts();
        if (new PreferencesMigrator(this).process(this.preferences)) {
            this.savePreferences();
        }
    }

    private EObject loadEMFModel(URI sourceURI) throws IOException {
        return EMFHelper.loadEMFModel((ResourceSet)this.resourceSet, (URI)sourceURI);
    }

    private Preferences loadPreferences() {
        IPath path = Activator.getDefault().getPreferencesPath();
        String preferencesPath = String.valueOf(path.toString()) + "/preferences.xmi";
        URI preferencesURI = URI.createFileURI((String)preferencesPath);
        try {
            EObject model = this.loadEMFModel(preferencesURI);
            if (model != null && model instanceof Preferences) {
                return (Preferences)model;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createPreferences(preferencesURI);
    }

    private Preferences createPreferences(URI preferencesURI) {
        Preferences preferencesStore = PreferencesFactory.eINSTANCE.createPreferences();
        preferencesStore.setVersion(2);
        Resource resource = this.resourceSet.createResource(preferencesURI);
        resource.getContents().add((Object)preferencesStore);
        this.saveModel(preferencesStore);
        return preferencesStore;
    }

    private void loadCustomContexts() {
        for (IContextStorageProvider provider : this.contextStorageRegistry.getStorageProviders()) {
            try {
                for (Context coreException : provider.loadContexts()) {
                    this.addContext(coreException, this.findDescriptor(coreException).isApplied(), true);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            provider.addContextStorageProviderListener(this.getContextStorageProviderListener());
        }
    }

    private IContextStorageProviderListener getContextStorageProviderListener() {
        if (this.contextStorageProviderListener == null) {
            this.contextStorageProviderListener = new IContextStorageProviderListener(){

                @Override
                public void contextsAdded(Collection<? extends Context> contexts) {
                    ArrayList<Context> appliedContexts = new ArrayList<Context>(contexts.size());
                    for (Context context : contexts) {
                        boolean applied = ConfigurationManager.this.findDescriptor(context).isApplied();
                        ConfigurationManager.this.addContext(context, applied, true);
                        if (!applied) continue;
                        appliedContexts.add(context);
                    }
                    if (!appliedContexts.isEmpty()) {
                        ConfigurationManager.this.notifyContextChanges(appliedContexts, IContextStorageProviderListener.ContextEventType.ADDED);
                    }
                }

                @Override
                public void contextsChanged(Collection<? extends Context> contexts) {
                    ArrayList<Context> appliedContexts = new ArrayList<Context>(contexts.size());
                    for (Context context : contexts) {
                        boolean applied = ConfigurationManager.this.findDescriptor(context).isApplied();
                        ConfigurationManager.this.reloadContext(context);
                        if (!applied) continue;
                        appliedContexts.add(context);
                    }
                    if (!appliedContexts.isEmpty()) {
                        ConfigurationManager.this.notifyContextChanges(appliedContexts, IContextStorageProviderListener.ContextEventType.CHANGED);
                    }
                }

                @Override
                public void contextsRemoved(Collection<? extends Context> contexts) {
                    ArrayList<Context> appliedContexts = new ArrayList<Context>(contexts.size());
                    for (Context context : contexts) {
                        boolean wasApplied = ConfigurationManager.this.findDescriptor(context).isApplied();
                        ConfigurationManager.this.deleteContext(context, false);
                        if (!wasApplied) continue;
                        appliedContexts.add(context);
                    }
                    if (!appliedContexts.isEmpty()) {
                        ConfigurationManager.this.notifyContextChanges(appliedContexts, IContextStorageProviderListener.ContextEventType.REMOVED);
                    }
                }
            };
        }
        return this.contextStorageProviderListener;
    }

    private void notifyContextChanges(Collection<Context> contexts, IContextStorageProviderListener.ContextEventType eventType) {
        String pattern;
        if (contexts.size() == 0) {
            throw new IllegalArgumentException("Empty contexts collection");
        }
        StringBuilder list = new StringBuilder();
        Iterator<Context> iter = contexts.iterator();
        if (contexts.size() > 1) {
            list.append("\n");
        }
        list.append(iter.next().getName());
        while (iter.hasNext()) {
            list.append("\n");
            list.append(iter.next().getName());
        }
        switch (eventType) {
            case ADDED: {
                pattern = "New Properties View configurations have been applied: {0}";
                break;
            }
            case REMOVED: {
                pattern = "Properties View configurations are no longer available: {0}";
                break;
            }
            default: {
                pattern = "Properties View configurations have changed: {0}";
            }
        }
        final String message = NLS.bind((String)pattern, (Object)list);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                NotificationBuilder.createAsyncPopup((String)message).setType(org.eclipse.papyrus.infra.widgets.toolbox.notification.Type.INFO).setDelay(5000L).run();
            }
        });
    }

    public void refresh(Context context) {
        IContextStorageProvider provider = this.contextStorageRegistry.getStorageProvider(context);
        if (provider != null) {
            try {
                provider.refreshContext(context);
                this.reloadContext(context);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private void reloadContext(Context context) {
        URI contextURI = EcoreUtil.getURI((EObject)context);
        if (this.contexts.containsKey(contextURI)) {
            Context previousContext = this.contexts.get(contextURI);
            this.enabledContexts.remove(previousContext);
            previousContext.eResource().unload();
            try {
                this.addContext(contextURI);
                this.constraintEngine.refresh();
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    public boolean isApplied(Context context) {
        boolean result;
        boolean bl = result = !this.isCustomizable(context) || this.findDescriptor(context).isApplied();
        if (!result) {
            EcoreUtil.CrossReferencer xrefs = new EcoreUtil.CrossReferencer(this.preferences){
                {
                    this.crossReference();
                    this.done();
                }

                protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                    return eReference == PreferencesPackage.Literals.CONTEXT_DESCRIPTOR__PROTOTYPE;
                }
            };
            LinkedList<ContextDescriptor> queue = new LinkedList<ContextDescriptor>();
            HashSet<ContextDescriptor> cycleDetect = new HashSet<ContextDescriptor>();
            queue.offer(this.findDescriptor(context));
            block0: while (!queue.isEmpty()) {
                ContextDescriptor desc = (ContextDescriptor)queue.remove();
                Collection refs = (Collection)xrefs.get((Object)desc);
                if (refs == null || !cycleDetect.add(desc)) continue;
                for (EStructuralFeature.Setting ref : refs) {
                    ContextDescriptor copy = (ContextDescriptor)ref.getEObject();
                    if (copy.isApplied()) {
                        if (this.getContext(copy.getName()) == null) {
                            result = true;
                            continue;
                        }
                        result = false;
                        break block0;
                    }
                    queue.offer(copy);
                }
            }
        }
        return result;
    }

    private ContextDescriptor findDescriptor(Context context) {
        ContextDescriptor descriptor2;
        if (context.getName() == null || context.getName().equals("")) {
            return null;
        }
        for (ContextDescriptor descriptor2 : this.preferences.getContexts()) {
            if (!descriptor2.getName().equals(context.getName())) continue;
            return descriptor2;
        }
        descriptor2 = PreferencesFactory.eINSTANCE.createContextDescriptor();
        descriptor2.setName(context.getName());
        this.preferences.getContexts().add((Object)descriptor2);
        this.savePreferences();
        return descriptor2;
    }

    public void addContext(URI uri, boolean customizable) throws IOException {
        EObject firstRootObject = this.loadEMFModel(uri);
        if (firstRootObject != null) {
            for (EObject rootObject : firstRootObject.eResource().getContents()) {
                if (!(rootObject instanceof Context)) continue;
                Context context = (Context)rootObject;
                this.addContext(context, this.findDescriptor(context).isApplied(), customizable);
            }
        }
    }

    public void addContext(URI uri) throws IOException {
        this.addContext(uri, true);
    }

    public void addContext(Context context, boolean apply) {
        this.addContext(context, apply, true);
    }

    private void updatePrototype(Context context) {
        Context prototype = context.getPrototype();
        if (prototype == null || !prototype.eIsProxy()) {
            ContextDescriptor desc = this.findDescriptor(context);
            ContextDescriptor oldPrototype = desc.getPrototype();
            desc.setPrototype(prototype == null ? null : this.findDescriptor(prototype));
            if (desc.getPrototype() != oldPrototype) {
                this.savePreferences();
            }
        }
    }

    public void addContext(Context context, boolean apply, boolean isCustomizable) {
        this.customizableContexts.put(context, isCustomizable);
        this.contexts.put(EcoreUtil.getURI((EObject)context), context);
        this.updatePrototype(context);
        ContextDescriptor desc = this.findDescriptor(context);
        if (desc.isDeleted()) {
            desc.setDeleted(false);
            this.savePreferences();
        }
        if (apply || !isCustomizable) {
            this.enableContext(context, true);
        } else {
            this.disableContext(context, true);
        }
        this.reconcileEnabledContexts();
    }

    public Collection<Context> getEnabledContexts() {
        return this.enabledContexts;
    }

    public void disableContext(Context context, boolean update) {
        this.disableContext(context, update, true);
    }

    private void disableContext(Context context, boolean updateEngine, boolean updatePreferences) {
        boolean missing = this.isMissing(context);
        if (!missing && !this.isCustomizable(context)) {
            throw new IllegalStateException("Non-customizable contexts cannot be disabled. Trying to disable " + context.getName());
        }
        updateEngine = this.enabledContexts.remove(context) && updateEngine;
        ContextDescriptor descriptor = this.findDescriptor(context);
        if (updatePreferences && descriptor.isApplied()) {
            descriptor.setApplied(false);
            this.savePreferences();
        }
        if (updateEngine) {
            this.update();
        }
    }

    public void enableContext(Context context, boolean update) {
        this.enableContext(context, update, true);
    }

    private void enableContext(Context context, boolean updateEngine, boolean updatePreferences) {
        boolean missing = this.isMissing(context);
        if (!missing) {
            this.enabledContexts.add(context);
        }
        ContextDescriptor descriptor = this.findDescriptor(context);
        if (updatePreferences && !descriptor.isApplied()) {
            descriptor.setApplied(true);
            this.savePreferences();
        }
        if (updateEngine && !missing) {
            this.constraintEngine.addContext(context);
        }
    }

    public boolean isPlugin(Context context) {
        boolean result = !this.isMissing(context) && this.contextStorageRegistry.getStorageProvider(context) == IContextStorageProvider.NULL;
        return result;
    }

    public boolean isMissing(Context context) {
        return !this.contexts.containsValue(context) && !this.findDescriptor(context).isDeleted();
    }

    public Context getContext(URI uri) throws IOException {
        return (Context)this.loadEMFModel(uri);
    }

    private void addEnvironment(Environment environment) {
        this.root.getEnvironments().add((Object)environment);
    }

    public void addEnvironment(URI uri) throws IOException {
        Environment environment = (Environment)this.loadEMFModel(uri);
        this.addEnvironment(environment);
    }

    public PropertiesRoot getPropertiesRoot() {
        return this.root;
    }

    public Context getContext(String contextName) {
        for (Context context : this.getContexts()) {
            if (!context.getName().equals(contextName)) continue;
            return context;
        }
        return null;
    }

    private void savePreferences() {
        this.saveModel(this.preferences);
    }

    private void saveModel(EObject eObject) {
        try {
            eObject.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Collection<Context> getContexts() {
        return this.contexts.values();
    }

    public Collection<Context> getCustomizableContexts() {
        LinkedList<Context> result = new LinkedList<Context>();
        for (Context context : this.contexts.values()) {
            if (!this.isCustomizable(context)) continue;
            result.add(context);
        }
        return result;
    }

    public Collection<Context> getMissingContexts() {
        ArrayList<Context> result = new ArrayList<Context>();
        for (ContextDescriptor next : this.preferences.getContexts()) {
            if (next.isDeleted() || this.getContext(next.getName()) != null) continue;
            Context missing = ContextsFactory.eINSTANCE.createContext();
            missing.setName(next.getName());
            result.add(missing);
        }
        return result;
    }

    private <T extends WidgetType> T getDefaultWidget(int featureID, Class<T> theClass, String widgetName, String namespacePrefix) {
        EStructuralFeature feature = EnvironmentPackage.Literals.ENVIRONMENT.getEStructuralFeature(featureID);
        for (Environment environment : this.root.getEnvironments()) {
            T widget = this.findWidgetTypeByClassName((Collection<T>)((EList)environment.eGet(feature)), widgetName, namespacePrefix);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    private <T extends WidgetType> T findWidgetTypeByClassName(Collection<T> types, String className, String namespacePrefix) {
        for (WidgetType widgetType : types) {
            if (!widgetType.getWidgetClass().equals(className) || !PropertiesUtil.namespaceEqualsByName(widgetType.getNamespace(), namespacePrefix)) continue;
            return (T)widgetType;
        }
        return null;
    }

    public CompositeWidgetType getDefaultCompositeType() {
        return this.getDefaultWidget(4, CompositeWidgetType.class, "Composite", "");
    }

    public LayoutType getDefaultLayoutType() {
        return this.getDefaultWidget(5, LayoutType.class, "PropertiesLayout", "ppel");
    }

    public StandardWidgetType getDefaultWidgetType() {
        return this.getDefaultWidget(2, StandardWidgetType.class, "Label", "");
    }

    public PropertyEditorType getDefaultEditorType(Type propertyType, boolean multiple) {
        String propertyEditorName = null;
        switch (propertyType) {
            case BOOLEAN: {
                propertyEditorName = multiple ? "MultiBoolean" : "BooleanRadio";
                break;
            }
            case ENUMERATION: {
                propertyEditorName = multiple ? "MultiEnum" : "EnumCombo";
                break;
            }
            case INTEGER: {
                propertyEditorName = multiple ? "MultiInteger" : "IntegerEditor";
                break;
            }
            case REFERENCE: {
                propertyEditorName = multiple ? "MultiReference" : "ReferenceDialog";
                break;
            }
            case STRING: {
                String string = propertyEditorName = multiple ? "MultiString" : "StringEditor";
            }
        }
        if (propertyEditorName == null) {
            return null;
        }
        return this.getDefaultWidget(3, PropertyEditorType.class, propertyEditorName, "ppe");
    }

    public Set<Namespace> getBaseNamespaces() {
        HashSet<Namespace> result = new HashSet<Namespace>();
        result.add(this.getNamespaceByName(""));
        result.add(this.getNamespaceByName("x"));
        result.add(this.getNamespaceByName("j"));
        return result;
    }

    public Namespace getNamespaceByName(String name) {
        for (Environment environment : this.root.getEnvironments()) {
            for (Namespace namespace : environment.getNamespaces()) {
                if (!PropertiesUtil.namespaceEqualsByName(namespace, name)) continue;
                return namespace;
            }
        }
        Activator.log.warn("Cannot find a registered namespace for '" + name + "'");
        return null;
    }

    public PropertyEditorType getDefaultEditorType(Property property) {
        return this.getDefaultEditorType(property.getType(), property.getMultiplicity() != 1);
    }

    public void deleteContext(Context context) {
        this.findDescriptor(context).setDeleted(true);
        this.deleteContext(context, true);
    }

    private void deleteContext(Context context, boolean updatePreferences) {
        if (!this.isCustomizable(context)) {
            throw new IllegalStateException("Non-customizable contexts cannot be deleted. Trying to delete " + context.getName());
        }
        Resource resource = context.eResource();
        this.contexts.remove(EcoreUtil.getURI((EObject)context));
        this.disableContext(context, true, updatePreferences);
        this.root.getContexts().remove((Object)context);
        resource.unload();
        this.resourceSet.getResources().remove((Object)resource);
        this.reconcileEnabledContexts();
    }

    private boolean reconcileEnabledContexts() {
        boolean result = false;
        for (Context next : this.contexts.values()) {
            boolean isApplied;
            if (next.eIsProxy() || (isApplied = this.isApplied(next)) == this.enabledContexts.contains(next)) continue;
            if (isApplied) {
                result = this.enabledContexts.add(next) || result;
                continue;
            }
            boolean bl = result = this.enabledContexts.remove(next) || result;
        }
        if (result) {
            this.update();
        }
        return result;
    }

    public static void init() {
        instance.start();
    }

    public Property getProperty(String propertyPath, Context context) {
        String elementName = propertyPath.substring(0, propertyPath.lastIndexOf(":"));
        String propertyName = propertyPath.substring(propertyPath.lastIndexOf(":") + 1, propertyPath.length());
        HashSet elements = new HashSet();
        Collection<Context> allContexts = context == null ? this.getContexts() : PropertiesUtil.getDependencies(context);
        for (Context ctx : allContexts) {
            elements.addAll(ctx.getDataContexts());
        }
        DataContextElement element = PropertiesUtil.getContextElementByQualifiedName(elementName, elements);
        if (element != null) {
            for (Property property : element.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        }
        return null;
    }

    public void update() {
        this.constraintEngine.refresh();
    }

    public Collection<ConfigurationConflict> checkConflicts() {
        HashMap sections = new HashMap();
        HashMap<String, ConfigurationConflict> conflicts = new HashMap<String, ConfigurationConflict>();
        for (Context context : this.getEnabledContexts()) {
            for (Tab tab : context.getTabs()) {
                for (Section section : tab.getSections()) {
                    String sectionID = section.getName();
                    LinkedList<Context> contexts = (LinkedList<Context>)sections.get(sectionID);
                    if (contexts == null) {
                        contexts = new LinkedList<Context>();
                        sections.put(sectionID, contexts);
                    } else {
                        ConfigurationConflict conflict = (ConfigurationConflict)conflicts.get(sectionID);
                        if (conflict == null) {
                            conflict = new ConfigurationConflict(sectionID);
                            conflicts.put(sectionID, conflict);
                            conflict.addContext((Context)contexts.get(0));
                        }
                        conflict.addContext(context);
                    }
                    contexts.add(context);
                }
            }
        }
        return conflicts.values();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public boolean isCustomizable(Context propertyViewConfiguration) {
        if (this.isMissing(propertyViewConfiguration)) {
            return true;
        }
        if (this.customizableContexts.containsKey(propertyViewConfiguration)) {
            return this.customizableContexts.get(propertyViewConfiguration);
        }
        return false;
    }
}

