/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.text.MessageFormat;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;

public class BlameInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private IInformationControlCreator creator;
    private BlameRevision revision;
    private ScrolledComposite scrolls;
    private Composite displayArea;
    private StyledText commitLink;
    private Label authorLabel;
    private Label committerLabel;
    private StyledText messageText;

    public BlameInformationControl(Shell parentShell, boolean isResizable, IInformationControlCreator creator) {
        super(parentShell, isResizable);
        this.creator = creator;
        this.create();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.creator;
    }

    public boolean hasContents() {
        return true;
    }

    protected void createContent(Composite parent) {
        this.scrolls = new ScrolledComposite(parent, 768);
        this.scrolls.setExpandHorizontal(true);
        this.scrolls.setExpandVertical(true);
        this.displayArea = new Composite((Composite)this.scrolls, 0);
        this.scrolls.setContent((Control)this.displayArea);
        this.displayArea.setForeground(parent.getForeground());
        this.displayArea.setBackground(parent.getBackground());
        this.displayArea.setBackgroundMode(2);
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo(this.displayArea);
        this.commitLink = new StyledText(this.displayArea, 8);
        this.commitLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BlameInformationControl.this.commitLink.getSelectionText().length() != 0) {
                    return;
                }
                try {
                    BlameInformationControl.this.getShell().dispose();
                    CommitEditor.open(new RepositoryCommit(BlameInformationControl.this.revision.getRepository(), BlameInformationControl.this.revision.getCommit()));
                }
                catch (PartInitException pie) {
                    Activator.logError(pie.getLocalizedMessage(), pie);
                }
            }
        });
        this.commitLink.setFont(JFaceResources.getBannerFont());
        this.commitLink.setForeground(JFaceColors.getHyperlinkText((Display)this.commitLink.getDisplay()));
        Cursor handCursor = new Cursor((Device)this.commitLink.getDisplay(), 21);
        UIUtils.hookDisposal((Widget)this.commitLink, (Resource)handCursor);
        this.commitLink.setCursor(handCursor);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commitLink);
        this.authorLabel = new Label(this.displayArea, 0);
        this.authorLabel.setForeground(parent.getForeground());
        this.authorLabel.setBackground(parent.getBackground());
        this.authorLabel.setFont(UIUtils.getItalicFont("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.authorLabel);
        this.committerLabel = new Label(this.displayArea, 0);
        this.committerLabel.setForeground(parent.getForeground());
        this.committerLabel.setBackground(parent.getBackground());
        this.committerLabel.setFont(UIUtils.getItalicFont("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.committerLabel);
        Label separator = new Label(this.displayArea, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        this.messageText = new StyledText(this.displayArea, 0);
        this.messageText.setForeground(parent.getForeground());
        this.messageText.setBackground(parent.getBackground());
        this.messageText.setEditable(false);
        this.messageText.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.messageText);
    }

    public Point computeSizeHint() {
        Point computed = this.getShell().computeSize(-1, -1, true);
        Point constraints = this.getSizeConstraints();
        if (constraints == null) {
            return computed;
        }
        Point constrainedSize = this.getShell().computeSize(constraints.x, -1, true);
        int width = Math.min(computed.x, constrainedSize.x);
        int height = Math.max(computed.y, constrainedSize.y);
        return new Point(width, height);
    }

    private void setControlVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    public void setInput(Object input) {
        this.revision = (BlameRevision)((Object)input);
        RevCommit commit = this.revision.getCommit();
        String linkText = MessageFormat.format(UIText.BlameInformationControl_Commit, commit.name());
        this.commitLink.setText(linkText);
        StyleRange styleRange = new StyleRange(0, linkText.length(), null, null);
        styleRange.underline = true;
        this.commitLink.setStyleRange(styleRange);
        PersonIdent author = commit.getAuthorIdent();
        if (author != null) {
            this.setControlVisible((Control)this.authorLabel, true);
            this.authorLabel.setText(MessageFormat.format(UIText.BlameInformationControl_Author, author.getName(), author.getEmailAddress(), author.getWhen()));
        } else {
            this.setControlVisible((Control)this.authorLabel, false);
        }
        PersonIdent committer = commit.getCommitterIdent();
        this.setControlVisible((Control)this.authorLabel, author != null);
        if (committer != null && !committer.equals((Object)author)) {
            this.setControlVisible((Control)this.committerLabel, true);
            this.committerLabel.setText(MessageFormat.format(UIText.BlameInformationControl_Committer, committer.getName(), committer.getEmailAddress(), committer.getWhen()));
        } else {
            this.setControlVisible((Control)this.committerLabel, false);
        }
        this.messageText.setText(commit.getFullMessage());
        this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
    }
}

