/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.factory;

import java.lang.reflect.Constructor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.table.common.Activator;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNattableEditorFactory
extends AbstractEditorFactory {
    public AbstractNattableEditorFactory(Class<?> editorClass, String editorType) {
        super(editorClass, editorType);
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new NattableEditorModel(pageIdentifier, this.getServiceRegistry());
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        if (pageIdentifier instanceof PapyrusTableInstance) {
            return this.getExpectedType().equals(((PapyrusTableInstance)pageIdentifier).getType());
        }
        return false;
    }

    class NattableEditorModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private PapyrusTableInstance rawModel;

        public NattableEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry) {
            this.rawModel = (PapyrusTableInstance)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                Constructor c = AbstractNattableEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, PapyrusTableInstance.class);
                IEditorPart newEditor = (IEditorPart)c.newInstance(this.servicesRegistry, this.rawModel);
                return newEditor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create TextEditor", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = AbstractNattableEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }

        public Image getTabIcon() {
            ImageDescriptor imageDescriptor = AbstractNattableEditorFactory.this.getEditorDescriptor().getIcon();
            if (imageDescriptor == null) {
                return null;
            }
            return imageDescriptor.createImage();
        }

        public String getTabTitle() {
            return this.rawModel.getName();
        }
    }
}

