/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.metamodel;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.standard.ExtensionIds;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;

public class RegisteredMetamodel
extends RegisteredElementExtensionPoint {
    private static final String TAG_METAMODEL = "metamodel";
    private static RegisteredMetamodel[] RegisteredMetamodels;

    public RegisteredMetamodel(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
    }

    public static RegisteredMetamodel[] getRegisteredMetamodels() {
        if (RegisteredMetamodels != null) {
            return RegisteredMetamodels;
        }
        ArrayList<RegisteredMetamodel> metamodels = new ArrayList<RegisteredMetamodel>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionIds.METAMODEL_EXTENSION_ID);
        int j = 0;
        while (j < configElements.length) {
            RegisteredMetamodel proxy = RegisteredMetamodel.parseMetamodelExtension(configElements[j], metamodels.size());
            if (proxy != null) {
                metamodels.add(proxy);
            }
            ++j;
        }
        RegisteredMetamodels = metamodels.toArray(new RegisteredMetamodel[metamodels.size()]);
        return RegisteredMetamodels;
    }

    public static RegisteredMetamodel getRegisteredMetamodel(String name) {
        return RegisteredMetamodel.getRegisteredMetamodel(name, null);
    }

    public static RegisteredMetamodel getRegisteredMetamodel(String name, String path) {
        Assert.isNotNull((Object)name);
        RegisteredMetamodel[] metamodels = RegisteredMetamodel.getRegisteredMetamodels();
        int i = 0;
        while (i < metamodels.length) {
            RegisteredMetamodel metamodel = metamodels[i];
            if (name.equals(metamodel.name)) {
                if (path == null) {
                    return metamodel;
                }
                if (path.equals(metamodel.path)) {
                    return metamodel;
                }
            }
            ++i;
        }
        return null;
    }

    private static RegisteredMetamodel parseMetamodelExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_METAMODEL.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredMetamodel(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load metamodel named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

