/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transaction;

import org.eclipse.emf.cdo.CDONotification;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class CDOPostEventTransactionHandler
implements CDOTransactionHandler {
    private final Adapter ATTACHED_ADAPTER = new PostEventAdapter(){

        protected void postEvent(CDOTransaction transaction, CDOObject object, Notification msg) {
            CDOPostEventTransactionHandler.this.attachedObject(transaction, object, msg);
        }
    };
    private final Adapter MODIFIED_ADAPTER = new PostEventAdapter(){

        protected void postEvent(CDOTransaction transaction, CDOObject object, Notification msg) {
            CDOPostEventTransactionHandler.this.modifiedObject(transaction, object, msg);
        }
    };
    private final Adapter DEATTACHED_ADAPTER = new PostEventAdapter(){

        protected void postEvent(CDOTransaction transaction, CDOObject object, Notification msg) {
            CDOPostEventTransactionHandler.this.detachedObject(transaction, object, msg);
        }
    };

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        object.eAdapters().add((Object)this.ATTACHED_ADAPTER);
    }

    public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
        object.eAdapters().add((Object)this.MODIFIED_ADAPTER);
    }

    public void detachingObject(CDOTransaction transaction, CDOObject object) {
        object.eAdapters().add((Object)this.DEATTACHED_ADAPTER);
    }

    public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
    }

    public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
    }

    public void rolledBackTransaction(CDOTransaction transaction) {
    }

    protected abstract void attachedObject(CDOTransaction var1, CDOObject var2, Notification var3);

    protected abstract void modifiedObject(CDOTransaction var1, CDOObject var2, Notification var3);

    protected abstract void detachedObject(CDOTransaction var1, CDOObject var2, Notification var3);

    public static class Default
    extends CDOPostEventTransactionHandler {
        protected void attachedObject(CDOTransaction transaction, CDOObject object, Notification msg) {
        }

        protected void modifiedObject(CDOTransaction transaction, CDOObject object, Notification msg) {
        }

        protected void detachedObject(CDOTransaction transaction, CDOObject object, Notification msg) {
        }
    }

    private static abstract class PostEventAdapter
    extends AdapterImpl {
        private PostEventAdapter() {
        }

        public void notifyChanged(Notification msg) {
            CDOObject object;
            EList adapters;
            Object notifier;
            if (msg instanceof CDONotification) {
                return;
            }
            if (this.isModifyingEvent(msg.getEventType()) && (notifier = msg.getNotifier()) instanceof EObject && (adapters = (object = CDOUtil.getCDOObject((EObject)notifier)).eAdapters()).contains((Object)this)) {
                this.postEvent((CDOTransaction)object.cdoView(), object, msg);
                boolean eDeliver = object.eDeliver();
                try {
                    object.eSetDeliver(false);
                    adapters.remove((Object)this);
                }
                finally {
                    object.eSetDeliver(eDeliver);
                }
            }
        }

        private boolean isModifyingEvent(int eventType) {
            switch (eventType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        protected abstract void postEvent(CDOTransaction var1, CDOObject var2, Notification var3);
    }
}

