/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.properties.provider;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;

public class PasteElementContainmentFeatureContentProvider
extends AbstractStaticContentProvider
implements ITreeContentProvider {
    private PapyrusTableInstance contextTable;

    public PasteElementContainmentFeatureContentProvider(PapyrusTableInstance contextTable) {
        this.contextTable = contextTable;
    }

    public EClass[] getElements() {
        EObject context = this.contextTable.getTable().getContext();
        if (context == null) {
            return new EClass[0];
        }
        EClass contextMetaclass = context.eClass();
        return new EClass[]{contextMetaclass};
    }

    public EReference[] getChildren(Object parentElement) {
        if (parentElement instanceof EClass) {
            EClass contextMetaclass = (EClass)parentElement;
            LinkedList<EReference> result = new LinkedList<EReference>();
            for (EReference reference : contextMetaclass.getEAllReferences()) {
                if (!reference.isContainment() || reference.getUpperBound() == 1) continue;
                result.add(reference);
            }
            return result.toArray(new EReference[result.size()]);
        }
        return new EReference[0];
    }

    public Object getParent(Object element) {
        if (element instanceof EReference) {
            return ((EReference)element).getEContainingClass();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

