/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.contexts.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.ContextItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.DataContextElementItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.DataContextPackageItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.DataContextRootItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.PropertyItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.SectionItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.TabItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.UnknownPropertyItemProvider;
import org.eclipse.papyrus.views.properties.contexts.provider.ViewItemProvider;
import org.eclipse.papyrus.views.properties.contexts.util.ContextsAdapterFactory;

public class ContextsItemProviderAdapterFactory
extends ContextsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected ContextItemProvider contextItemProvider;
    protected TabItemProvider tabItemProvider;
    protected ViewItemProvider viewItemProvider;
    protected SectionItemProvider sectionItemProvider;
    protected DataContextElementItemProvider dataContextElementItemProvider;
    protected PropertyItemProvider propertyItemProvider;
    protected UnknownPropertyItemProvider unknownPropertyItemProvider;
    protected DataContextPackageItemProvider dataContextPackageItemProvider;
    protected DataContextRootItemProvider dataContextRootItemProvider;

    public ContextsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createContextAdapter() {
        if (this.contextItemProvider == null) {
            this.contextItemProvider = new ContextItemProvider((AdapterFactory)this);
        }
        return this.contextItemProvider;
    }

    public Adapter createTabAdapter() {
        if (this.tabItemProvider == null) {
            this.tabItemProvider = new TabItemProvider((AdapterFactory)this);
        }
        return this.tabItemProvider;
    }

    public Adapter createViewAdapter() {
        if (this.viewItemProvider == null) {
            this.viewItemProvider = new ViewItemProvider((AdapterFactory)this);
        }
        return this.viewItemProvider;
    }

    public Adapter createSectionAdapter() {
        if (this.sectionItemProvider == null) {
            this.sectionItemProvider = new SectionItemProvider((AdapterFactory)this);
        }
        return this.sectionItemProvider;
    }

    public Adapter createDataContextElementAdapter() {
        if (this.dataContextElementItemProvider == null) {
            this.dataContextElementItemProvider = new DataContextElementItemProvider((AdapterFactory)this);
        }
        return this.dataContextElementItemProvider;
    }

    public Adapter createPropertyAdapter() {
        if (this.propertyItemProvider == null) {
            this.propertyItemProvider = new PropertyItemProvider((AdapterFactory)this);
        }
        return this.propertyItemProvider;
    }

    public Adapter createUnknownPropertyAdapter() {
        if (this.unknownPropertyItemProvider == null) {
            this.unknownPropertyItemProvider = new UnknownPropertyItemProvider((AdapterFactory)this);
        }
        return this.unknownPropertyItemProvider;
    }

    public Adapter createDataContextPackageAdapter() {
        if (this.dataContextPackageItemProvider == null) {
            this.dataContextPackageItemProvider = new DataContextPackageItemProvider((AdapterFactory)this);
        }
        return this.dataContextPackageItemProvider;
    }

    public Adapter createDataContextRootAdapter() {
        if (this.dataContextRootItemProvider == null) {
            this.dataContextRootItemProvider = new DataContextRootItemProvider((AdapterFactory)this);
        }
        return this.dataContextRootItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.contextItemProvider != null) {
            this.contextItemProvider.dispose();
        }
        if (this.tabItemProvider != null) {
            this.tabItemProvider.dispose();
        }
        if (this.viewItemProvider != null) {
            this.viewItemProvider.dispose();
        }
        if (this.sectionItemProvider != null) {
            this.sectionItemProvider.dispose();
        }
        if (this.dataContextElementItemProvider != null) {
            this.dataContextElementItemProvider.dispose();
        }
        if (this.propertyItemProvider != null) {
            this.propertyItemProvider.dispose();
        }
        if (this.unknownPropertyItemProvider != null) {
            this.unknownPropertyItemProvider.dispose();
        }
        if (this.dataContextPackageItemProvider != null) {
            this.dataContextPackageItemProvider.dispose();
        }
        if (this.dataContextRootItemProvider != null) {
            this.dataContextRootItemProvider.dispose();
        }
    }
}

