/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.edit.policies;

import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.commands.ConnectionPointReferenceCreateCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.commands.RegionCreateCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class StateCompartmentItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public StateCompartmentItemSemanticEditPolicy() {
        super(UMLElementTypes.State_6000);
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return super.getCreateCommand(req);
        }
        IElementType baseElementType = requestElementType;
        boolean isExtendedType = false;
        if (requestElementType instanceof IExtendedHintedElementType) {
            baseElementType = ElementTypeUtils.getClosestDiagramType((IElementType)requestElementType);
            if (baseElementType != null) {
                isExtendedType = true;
            } else {
                baseElementType = ElementTypeUtils.findClosestNonExtendedElementType((IExtendedHintedElementType)((IExtendedHintedElementType)requestElementType));
                isExtendedType = true;
            }
        }
        if (UMLElementTypes.Region_3000 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new RegionCreateCommand(req));
        }
        if (UMLElementTypes.ConnectionPointReference_18000 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ConnectionPointReferenceCreateCommand(req));
        }
        return super.getCreateCommand(req);
    }
}

