/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.storage.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStorageActionUtil {
    private ContextStorageActionUtil() {
    }

    public static void initializeCopy(Context source, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.CopyContextAction_InitializingTheCopyOf) + source.getName() + Messages.CopyContextAction_ThisMayTakeSomeTime, -1);
        ContextStorageActionUtil.resolveAllResources(source);
        monitor.done();
    }

    private static void resolveAllResources(Context source) {
        ContextStorageActionUtil.resolveAllResources((EObject)source, new HashSet<EObject>());
    }

    private static void resolveAllResources(EObject source, Set<EObject> visitedEObjects) {
        if (!visitedEObjects.add(source)) {
            return;
        }
        for (EReference reference : source.eClass().getEAllReferences()) {
            if (reference == ContextsPackage.eINSTANCE.getSection_Widget()) continue;
            Object value = source.eGet((EStructuralFeature)reference);
            if (value instanceof EList) {
                for (Object object : (EList)value) {
                    if (!(object instanceof EObject)) continue;
                    ContextStorageActionUtil.resolveAllResources((EObject)object, visitedEObjects);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            ContextStorageActionUtil.resolveAllResources((EObject)value, visitedEObjects);
        }
    }

    public static boolean isRelative(Resource base, Resource resource) {
        URI baseURI = base.getURI();
        URI resourceURI = resource.getURI();
        URI uri = resourceURI.deresolve(baseURI);
        return uri.isRelative() && !uri.toString().startsWith("..") && !uri.toString().startsWith("/");
    }
}

