/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.ui.refactoring;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.DefaultReferenceUpdater;
import org.eclipse.xtext.util.ITextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLstdlibReferenceUpdater
extends DefaultReferenceUpdater {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating reference updates", (int)resource2references.keySet().size());
        for (URI referringResourceURI : resource2references.keySet()) {
            if (progress.isCanceled()) {
                return;
            }
            for (IReferenceDescription referenceDescription : resource2references.get((Object)referringResourceURI)) {
                this.createReferenceUpdate(referenceDescription, referringResourceURI, elementRenameArguments, resourceSet, updateAcceptor);
            }
            progress.worked(1);
        }
    }

    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        ITextRegion referenceTextRegion = this.locationInFileProvider.getSignificantTextRegion(referringElement, (EStructuralFeature)reference, indexInList);
        ReplaceEdit referenceEdit = new ReplaceEdit(referenceTextRegion.getOffset(), referenceTextRegion.getLength(), ((NamedElement)newTargetElement).getName());
        updateAcceptor.accept(referringResourceURI, (TextEdit)referenceEdit);
    }
}

