/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.ui.registrations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ocl.examples.modelregistry.ui.registrations.RegistrationsContentProvider;
import org.eclipse.ocl.examples.modelregistry.ui.registrations.RegistrationsLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RegistrationsView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.ocl.modelregistry.registrations";
    private TreeViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;

    public void createPartControl(Composite parent) {
        System.out.println("createPartControl  " + parent);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new RegistrationsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RegistrationsLabelProvider());
        Tree tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn c1 = new TreeColumn(tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        c1.setText("name");
        TreeColumn c2 = new TreeColumn(tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        c2.setText("value");
        TreeColumn c3 = new TreeColumn(tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        c3.setText("resolution");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.ocl.modelregistry.explorer.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        int i = 0;
        while (i < 3) {
            this.viewer.getLabelProvider(i);
            ++i;
        }
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.addSelectionListener((ISelectionListener)this);
        this.viewer.setInput((Object)service.getSelection());
    }

    public void dispose() {
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        System.out.println("selectionChanged to " + selection);
        Object input = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                input = firstElement;
            } else if (firstElement instanceof IAdaptable && (firstElement = ((IAdaptable)firstElement).getAdapter(IResource.class)) instanceof IResource) {
                input = firstElement;
            }
        }
        this.viewer.setInput(input);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RegistrationsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                RegistrationsView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                RegistrationsView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RegistrationsView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                RegistrationsView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RegistrationsView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Registrations View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

