/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.definition;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.uml.profile.definition.Version;

public class PapyrusDefinitionAnnotation {
    private Version version = Version.emptyVersion;
    private String comment = "";
    private String copyright = "";
    private String date = "";
    private String author = "";
    public static PapyrusDefinitionAnnotation UNDEFINED_ANNOTATION = new PapyrusDefinitionAnnotation(Version.emptyVersion, "<undefined>", "", "", "<undefined>");

    public PapyrusDefinitionAnnotation(Version version, String comment, String copyright, String date, String author) {
        this.version = version;
        this.comment = comment;
        this.copyright = copyright;
        this.author = author;
        this.date = date;
    }

    public EAnnotation convertToEAnnotation() {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("PapyrusVersion");
        annotation.getDetails().put((Object)"Version", (Object)this.version.toString());
        annotation.getDetails().put((Object)"Comment", (Object)this.comment);
        annotation.getDetails().put((Object)"Copyright", (Object)this.copyright);
        annotation.getDetails().put((Object)"Date", (Object)this.date);
        annotation.getDetails().put((Object)"Author", (Object)this.author);
        return annotation;
    }

    public static PapyrusDefinitionAnnotation parseEAnnotation(EAnnotation annotation) {
        Version version;
        String versionValue = (String)annotation.getDetails().get((Object)"Version");
        try {
            version = Version.parseVersion(versionValue);
        }
        catch (IllegalArgumentException e) {
            version = Version.emptyVersion;
        }
        String comment = (String)annotation.getDetails().get((Object)"Comment");
        String copyright = (String)annotation.getDetails().get((Object)"Copyright");
        String date = (String)annotation.getDetails().get((Object)"Date");
        String author = (String)annotation.getDetails().get((Object)"Author");
        return new PapyrusDefinitionAnnotation(version, comment != null ? comment : "", copyright != null ? copyright : "", date != null ? date : "", author != null ? author : "");
    }

    public Version getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }
}

