/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElementFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeModelElementFactory
implements ModelElementFactory {
    public ModelElement createFromSource(Object source, DataContextElement context) {
        Element umlElement = UMLUtil.resolveUMLElement((Object)source);
        if (umlElement != null) {
            Stereotype stereotype = UMLUtil.getAppliedStereotype((Element)umlElement, (String)this.getQualifiedName(context), (boolean)false);
            EObject stereotypeApplication = umlElement.getStereotypeApplication(stereotype);
            if (stereotypeApplication == null) {
                Activator.log.warn("Stereotype " + this.getQualifiedName(context) + " is not applied on " + umlElement);
            } else {
                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)stereotypeApplication);
                return new StereotypeModelElement(stereotypeApplication, stereotype, domain);
            }
        }
        return null;
    }

    protected String getQualifiedName(DataContextElement context) {
        if (context.getPackage() == null) {
            return context.getName();
        }
        return String.valueOf(this.getQualifiedName((DataContextElement)context.getPackage())) + "::" + context.getName();
    }
}

