/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositeforview;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.IViewComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.ProfileElementWithDisplayContentProvider;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.ProfileElementWithDisplayLabelProvider;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.AppliedStereotypeCompositeOnModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompositeWithView
extends AppliedStereotypeCompositeOnModel
implements IViewComposite {
    protected ISelection selection;
    protected MultipleReferenceEditor propertyComposite;
    private EModelElement diagramElement;
    private ISelectionChangedListener propertySelectionChangeListener;

    public AppliedStereotypeCompositeWithView(Composite parent) {
        super(parent);
        this.setBackground(JFaceColors.getBannerBackground((Display)parent.getDisplay()));
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementWithDisplayContentProvider(this.diagramElement));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementWithDisplayLabelProvider());
        this.refresh();
        return this;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void setDiagramElement(EModelElement diagramElement) {
        this.diagramElement = diagramElement;
        ((ProfileElementWithDisplayContentProvider)this.treeViewer.getContentProvider()).setDiagramElement(diagramElement);
    }

    public void setPropertySelectionChangeListener(ISelectionChangedListener propertySelectionChangeListener) {
        this.propertySelectionChangeListener = propertySelectionChangeListener;
    }

    @Deprecated
    public Element getSelected() {
        return this.getElement();
    }

    public void addButtonPressed() {
        super.addButtonPressed();
    }

    public void applyStereotype(Element elt, final Stereotype st) {
        super.applyStereotype(elt, st);
        if (this.diagramElement == null) {
            return;
        }
        try {
            final TransactionalEditingDomain domain = this.getEditingDomain(elt);
            domain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)domain, (EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            domain.getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void unapplyStereotype(Element elt, final Stereotype st) {
        super.unapplyStereotype(elt, st);
        if (this.diagramElement == null) {
            return;
        }
        final TransactionalEditingDomain domain = this.getEditingDomain(elt);
        try {
            domain.runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)domain, (EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            domain.getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeButtonPressed() {
        this.superRemoveButton();
    }

    private void superRemoveButton() {
        super.removeButtonPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.propertySelectionChangeListener.selectionChanged(event);
    }
}

