/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.pivot2cs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PathNameDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLDeclarationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLDeclarationVisitor
extends EssentialOCLDeclarationVisitor {
    public CompleteOCLDeclarationVisitor(@NonNull Pivot2CSConversion context) {
        super(context);
    }

    protected TypedRefCS convertTypeRef(@NonNull TypedMultiplicityElement object) {
        Type type = object.getType();
        if (type == null) {
            return null;
        }
        TypedRefCS typeRef = (TypedRefCS)((Pivot2CSConversion)this.context).visitReference(TypedRefCS.class, (EObject)type);
        return typeRef;
    }

    protected void gatherPackages(@NonNull List<Package> allPackages, @NonNull List<Package> nestedPackages) {
        allPackages.addAll(nestedPackages);
        for (Package nestedPackage : nestedPackages) {
            List nestedNestedPackages = nestedPackage.getNestedPackage();
            assert (nestedNestedPackages != null);
            this.gatherPackages(allPackages, nestedNestedPackages);
        }
    }

    protected void importPackage(@NonNull Package aPackage) {
        Package nestingPackage = null;
        while ((nestingPackage = aPackage.getNestingPackage()) != null) {
            aPackage = nestingPackage;
        }
        ((Pivot2CSConversion)this.context).importNamespace((Namespace)aPackage, null);
    }

    protected void refreshPathNamedElement(@NonNull PathNameDeclCS csDecl, @NonNull NamedElement namedElement, Namespace scope) {
        PathNameCS csPathName = csDecl.getPathName();
        if (csPathName == null) {
            csPathName = BaseCSTFactory.eINSTANCE.createPathNameCS();
            assert (csPathName != null);
            csDecl.setPathName(csPathName);
        }
        ((Pivot2CSConversion)this.context).refreshPathName(csPathName, (Element)namedElement, scope);
    }

    public ElementCS visitClass(@NonNull org.eclipse.ocl.examples.pivot.Class object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitConstraint(@NonNull Constraint object) {
        ConstraintCS csElement = (ConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(ConstraintCS.class, BaseCSTPackage.Literals.CONSTRAINT_CS, (NamedElement)object);
        if (csElement != null) {
            Namespace namespace = PivotUtil.getNamespace((EObject)object);
            OpaqueExpression specification = object.getSpecification();
            if (specification != null && namespace != null) {
                AliasAnalysis adapter;
                ExpSpecificationCS csSpec = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                csElement.setSpecification((SpecificationCS)csSpec);
                MetaModelManager metaModelManager = ((Pivot2CSConversion)this.context).getMetaModelManager();
                PrettyPrintOptions.Global prettyPrintOptions = PrettyPrinter.createOptions(null);
                ArrayList newArrayList = Lists.newArrayList((Object[])new String[]{"body", "context", "def", "endpackage", "inv", "package", "post", "inv"});
                prettyPrintOptions.addReservedNames((Iterable)newArrayList);
                prettyPrintOptions.setMetaModelManager(metaModelManager);
                Resource resource = object.eResource();
                AliasAnalysis aliasAnalysis = adapter = resource != null ? AliasAnalysis.getAdapter((Resource)resource) : null;
                if (adapter != null) {
                    for (DomainPackage aliased : adapter.getAliases()) {
                        String alias;
                        DomainPackage primary = metaModelManager.getPrimaryPackage(aliased);
                        if (!(primary instanceof Namespace) || (alias = adapter.getAlias((EObject)((Namespace)primary))) == null) continue;
                        prettyPrintOptions.addAliases((Namespace)primary, alias);
                    }
                }
                String expr = PrettyPrinter.print((Element)specification, (PrettyPrintOptions)prettyPrintOptions);
                csSpec.setExprString("\t" + expr.trim().replaceAll("\\r", "").replaceAll("\\n", "\n\t\t"));
                String message = PivotUtil.getMessage((OpaqueExpression)specification);
                if (message != null && message.length() > 0) {
                    ExpSpecificationCS csMessageElement = (ExpSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
                    csMessageElement.setExprString(message);
                    csElement.setMessageSpecification((SpecificationCS)csMessageElement);
                }
            }
        }
        return csElement;
    }

    public ElementCS visitOperation(@NonNull Operation object) {
        if (object.getPrecondition().size() <= 0 && object.getBodyExpression() == null && object.getPostcondition().size() <= 0) {
            return null;
        }
        Type modelType = object.getOwningType();
        Package modelPackage = modelType.getPackage();
        org.eclipse.ocl.examples.pivot.Class savedScope = ((Pivot2CSConversion)this.context).setScope((org.eclipse.ocl.examples.pivot.Class)modelType);
        OperationContextDeclCS csContext = (OperationContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(OperationContextDeclCS.class, CompleteOCLCSTPackage.Literals.OPERATION_CONTEXT_DECL_CS, (Element)object);
        if (csContext != null) {
            this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)modelPackage);
            csContext.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
            Package owningPackage = object.getOwningType().getPackage();
            if (owningPackage != null) {
                this.importPackage(owningPackage);
            }
            ((Pivot2CSConversion)this.context).refreshList(csContext.getParameters(), ((Pivot2CSConversion)this.context).visitDeclarations(ParameterCS.class, object.getOwnedParameter(), null));
            ((Pivot2CSConversion)this.context).refreshList(csContext.getPreconditions(), ((Pivot2CSConversion)this.context).visitDeclarations(ConstraintCS.class, object.getPrecondition(), null));
            ((Pivot2CSConversion)this.context).refreshList(csContext.getPostconditions(), ((Pivot2CSConversion)this.context).visitDeclarations(ConstraintCS.class, object.getPostcondition(), null));
            ((Pivot2CSConversion)this.context).refreshList(csContext.getBodies(), ((Pivot2CSConversion)this.context).visitDeclarationAsList(ExpSpecificationCS.class, (EObject)object.getBodyExpression()));
            ((Pivot2CSConversion)this.context).setScope(savedScope);
        }
        return csContext;
    }

    public ElementCS visitPackage(@NonNull Package object) {
        PackageDeclarationCS csPackage;
        PackageDeclarationCS csElement = null;
        assert (object.eContainer() != null);
        ArrayList<ContextDeclCS> contexts = new ArrayList<ContextDeclCS>();
        for (Type type : object.getOwnedType()) {
            assert (type != null);
            ClassifierContextDeclCS classifierContext = (ClassifierContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(ClassifierContextDeclCS.class, (EObject)type);
            if (classifierContext != null) {
                contexts.add(classifierContext);
            }
            for (Operation operation : type.getOwnedOperation()) {
                assert (operation != null);
                OperationContextDeclCS operationContext = (OperationContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(OperationContextDeclCS.class, (EObject)operation);
                if (operationContext == null) continue;
                contexts.add(operationContext);
            }
            for (Property property : type.getOwnedAttribute()) {
                assert (property != null);
                PropertyContextDeclCS propertyContext = (PropertyContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(PropertyContextDeclCS.class, (EObject)property);
                if (propertyContext == null) continue;
                contexts.add(propertyContext);
            }
        }
        if (contexts.size() > 0 && (csPackage = (PackageDeclarationCS)((Pivot2CSConversion)this.context).refreshElement(PackageDeclarationCS.class, CompleteOCLCSTPackage.Literals.PACKAGE_DECLARATION_CS, (Element)object)) != null) {
            this.refreshPathNamedElement(csPackage, (NamedElement)object, PivotUtil.getContainingNamespace((EObject)object));
            this.importPackage(object);
            ((Pivot2CSConversion)this.context).refreshList(csPackage.getContexts(), contexts);
            csElement = csPackage;
        }
        return csElement;
    }

    public ElementCS visitParameter(@NonNull Parameter object) {
        ParameterCS csElement = (ParameterCS)((Pivot2CSConversion)this.context).refreshNamedElement(ParameterCS.class, BaseCSTPackage.Literals.PARAMETER_CS, (NamedElement)object);
        csElement.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
        return csElement;
    }

    public ElementCS visitProperty(@NonNull Property object) {
        if (object.getDefaultExpression() == null) {
            return null;
        }
        Type modelType = object.getOwningType();
        Package modelPackage = modelType.getPackage();
        org.eclipse.ocl.examples.pivot.Class savedScope = ((Pivot2CSConversion)this.context).setScope((org.eclipse.ocl.examples.pivot.Class)modelType);
        PropertyContextDeclCS csContext = (PropertyContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(PropertyContextDeclCS.class, CompleteOCLCSTPackage.Literals.PROPERTY_CONTEXT_DECL_CS, (Element)object);
        if (csContext != null && modelPackage != null) {
            this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)modelPackage);
            csContext.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
            this.importPackage(modelPackage);
            ((Pivot2CSConversion)this.context).refreshList(csContext.getDefaultExpressions(), ((Pivot2CSConversion)this.context).visitDeclarationAsList(ExpSpecificationCS.class, (EObject)object.getDefaultExpression()));
            ((Pivot2CSConversion)this.context).setScope(savedScope);
        }
        return csContext;
    }

    protected <T extends ConstraintCS> void refreshPropertyConstraints(@NonNull Class<T> csConstraintClass, @NonNull List<? super T> csPropertyConstraints, Property object) {
        ConstraintCS csConstraint = null;
        OpaqueExpression defaultExpression = object.getDefaultExpression();
        if (defaultExpression != null) {
            csConstraint = (ConstraintCS)((Pivot2CSConversion)this.context).visitDeclaration(csConstraintClass, (EObject)defaultExpression);
        }
        if (csConstraint != null) {
            csConstraint.setStereotype("derivation");
            ((Pivot2CSConversion)this.context).refreshList(csPropertyConstraints, Collections.singletonList(csConstraint));
        } else {
            csPropertyConstraints.clear();
        }
    }

    public ElementCS visitRoot(@NonNull Root object) {
        assert (object.eContainer() == null);
        CompleteOCLDocumentCS csDocument = (CompleteOCLDocumentCS)((Pivot2CSConversion)this.context).refreshElement(CompleteOCLDocumentCS.class, CompleteOCLCSTPackage.Literals.COMPLETE_OCL_DOCUMENT_CS, (Element)object);
        ArrayList<Package> allPackages = new ArrayList<Package>();
        List nestedPackages = object.getNestedPackage();
        assert (nestedPackages != null);
        this.gatherPackages(allPackages, nestedPackages);
        ((Pivot2CSConversion)this.context).refreshList(csDocument.getPackages(), ((Pivot2CSConversion)this.context).visitDeclarations(PackageDeclarationCS.class, allPackages, null));
        CompleteOCLDocumentCS csElement = csDocument;
        return csElement;
    }

    public ElementCS visitType(@NonNull Type object) {
        List ownedInvariant = object.getOwnedInvariant();
        if (ownedInvariant.size() <= 0) {
            return null;
        }
        Package objectPackage = object.getPackage();
        ClassifierContextDeclCS csContext = (ClassifierContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(ClassifierContextDeclCS.class, CompleteOCLCSTPackage.Literals.CLASSIFIER_CONTEXT_DECL_CS, (Element)object);
        if (csContext != null && objectPackage != null) {
            this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)objectPackage);
            this.importPackage(objectPackage);
            ((Pivot2CSConversion)this.context).refreshList(csContext.getInvariants(), ((Pivot2CSConversion)this.context).visitDeclarations(ConstraintCS.class, ownedInvariant, null));
        }
        return csContext;
    }
}

