/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.validation;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.PivotEObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLEObjectValidator
extends PivotEObjectValidator {
    private static final Logger logger = Logger.getLogger(CompleteOCLEObjectValidator.class);
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final EPackage ePackage;
    @NonNull
    protected final URI oclURI;
    private Ecore2Pivot ecore2Pivot = null;

    @Deprecated
    public CompleteOCLEObjectValidator(@NonNull EPackage ePackage, @NonNull URI oclURI) {
        this(ePackage, oclURI, null);
    }

    public CompleteOCLEObjectValidator(@NonNull EPackage ePackage, @NonNull URI oclURI, @Nullable MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager != null ? metaModelManager : new MetaModelManager();
        this.ePackage = ePackage;
        this.oclURI = oclURI;
        ResourceSet resourceSet = ePackage.eResource().getResourceSet();
        if (resourceSet != null) {
            CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (MetaModelManager)this.metaModelManager);
        }
    }

    protected EPackage getEPackage() {
        return this.ePackage;
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public boolean initialize() {
        Resource ecoreResource = this.ePackage.eResource();
        if (ecoreResource == null) {
            return false;
        }
        this.ecore2Pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (MetaModelManager)this.metaModelManager);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (MetaModelManager)this.metaModelManager);
        EList errors = ecoreResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Ecore '" + ecoreResource.getURI() + message));
            return false;
        }
        Root pivotRoot = this.ecore2Pivot.getPivotRoot();
        errors = pivotRoot.eResource().getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + ecoreResource.getURI() + message));
            return false;
        }
        BaseResource xtextResource = null;
        try {
            xtextResource = (BaseResource)resourceSet.getResource(this.oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && this.oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)this.oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (BaseResource)resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        errors = xtextResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + this.oclURI + message));
            return false;
        }
        Resource pivotResource = xtextResource.getPivotResource(this.metaModelManager);
        errors = pivotResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + this.oclURI + message));
            return false;
        }
        return true;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @NonNull Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.ecore2Pivot == null) {
            ResourceSet resourceSet;
            this.initialize();
            Resource eResource = ((EObject)object).eResource();
            if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
                CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (MetaModelManager)this.metaModelManager);
            }
        }
        return super.validatePivot(eClassifier, object, diagnostics, context);
    }
}

