/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class PreformattedBlock
extends Block {
    private static final Pattern PRE_OPEN_PATTERN = Pattern.compile("(<pre((?:\\s+[a-zA-Z][a-zA-Z0-9_:-]*=\"[^\"]*\")*)\\s*>).*", 2);
    private static final Pattern PRE_CLOSE_PATTERN = Pattern.compile("(</pre*\\s*>)", 2);
    private int blockLineCount = 0;
    private boolean usesTag = false;

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && line.length() > 0 && line.charAt(0) == ' ') {
            this.usesTag = false;
            return true;
        }
        Matcher matcher = PRE_OPEN_PATTERN.matcher(line);
        if (lineOffset > 0) {
            matcher.region(lineOffset, line.length());
        }
        if (matcher.matches()) {
            this.usesTag = true;
            return true;
        }
        return false;
    }

    public int processLineContent(String line, int offset) {
        int lineStart;
        int n = lineStart = this.usesTag ? 0 : 1;
        if (this.blockLineCount++ == 0) {
            Attributes attributes = new Attributes();
            if (this.usesTag) {
                Matcher matcher = PRE_OPEN_PATTERN.matcher(line);
                if (offset > 0) {
                    matcher.region(offset, line.length());
                }
                if (matcher.matches()) {
                    String htmlAttributes = matcher.group(2);
                    this.processHtmlAttributes(attributes, htmlAttributes);
                    offset = lineStart = matcher.end(1);
                } else {
                    throw new IllegalStateException();
                }
            }
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
        }
        if (this.usesTag) {
            if (this.blockLineCount > 0) {
                Matcher closeMatcher = PRE_CLOSE_PATTERN.matcher(line);
                if (offset > 0) {
                    closeMatcher.region(offset, line.length());
                }
                if (closeMatcher.find()) {
                    int contentEnd = closeMatcher.start(1);
                    int newContentStart = closeMatcher.end(1);
                    if (contentEnd > 0) {
                        this.addContent(line.substring(0, contentEnd), offset);
                    }
                    this.setClosed(true);
                    if (newContentStart < line.length()) {
                        return newContentStart;
                    }
                    return -1;
                }
            }
        } else if (this.markupLanguage.isEmptyLine(line) || offset == 0 && line.charAt(0) != ' ') {
            this.setClosed(true);
            return 0;
        }
        if (line.length() >= lineStart) {
            this.addContent(line, lineStart);
        }
        return -1;
    }

    private void addContent(String line, int offset) {
        if (this.usesTag) {
            this.builder.characters(line.substring(offset));
        } else {
            this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, line, offset);
        }
        this.builder.characters("\n");
    }

    private void processHtmlAttributes(Attributes attributes, String htmlAttributes) {
        if (htmlAttributes != null) {
            Pattern pattern = Pattern.compile("\\s+([a-zA-Z][a-zA-Z0-9_:-]*)=\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(htmlAttributes);
            while (matcher.find()) {
                String attrName = matcher.group(1);
                String attrValue = matcher.group(2);
                if ("id".equals(attrName)) {
                    attributes.setId(attrValue);
                    continue;
                }
                if ("style".equals(attrName)) {
                    attributes.setCssStyle(attrValue);
                    continue;
                }
                if (!"class".equals(attrName)) continue;
                attributes.setCssClass(attrValue);
            }
        }
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
            this.usesTag = false;
        }
        super.setClosed(closed);
    }
}

