/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.diagram.common.compatibility;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;

public class DiagramVersioningUtils {
    private static final String DIAGRAM_COMPATIBILITY_VERSION = "diagram_compatibility_version";
    public static final String UNDEFINED_VERSION = "undefined";

    public static String getCompatibilityVersion(Diagram diagram) {
        StringValueStyle semanticStyle = (StringValueStyle)diagram.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), DIAGRAM_COMPATIBILITY_VERSION);
        return semanticStyle == null ? UNDEFINED_VERSION : semanticStyle.getStringValue();
    }

    public static void setCompatibilityVersion(Diagram diagram, String version) {
        StringValueStyle style = (StringValueStyle)diagram.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), DIAGRAM_COMPATIBILITY_VERSION);
        if (style == null) {
            style = NotationFactory.eINSTANCE.createStringValueStyle();
            style.setName(DIAGRAM_COMPATIBILITY_VERSION);
            diagram.getStyles().add((Object)style);
        }
        style.setStringValue(version);
    }
}

