/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.services.edit.commands.AbstractConfigureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.sysml.diagram.common.dialogs.CreateOrSelectConstraintPropertyTypeDialog;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateConstraintPropertyWithTypeConfigureCommandFactory
extends AbstractConfigureCommandFactory {
    public ICommand create(ConfigureRequest request) {
        ICommand configureCommand = null;
        Shell shell = Display.getDefault().getActiveShell();
        Property part = (Property)request.getElementToConfigure();
        Package partPkg = part.getNearestPackage();
        CreateOrSelectConstraintPropertyTypeDialog dialog = new CreateOrSelectConstraintPropertyTypeDialog(shell, (NamedElement)partPkg);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            final ICommand typeCreationCommand = dialog.getNewTypeCreateCommand();
            final Type partType = (Type)dialog.getExistingType();
            if (typeCreationCommand != null && !typeCreationCommand.canExecute()) {
                return this.cancelCommand(request);
            }
            configureCommand = CompositeCommand.compose(configureCommand, (ICommand)typeCreationCommand);
            ConfigureElementCommand setTypeCommand = new ConfigureElementCommand(request){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Property part = (Property)this.getElementToEdit();
                    if (partType != null) {
                        part.setType(partType);
                    } else {
                        Type newType = (Type)GMFCommandUtils.getCommandEObjectResult((ICommand)typeCreationCommand);
                        this.createConstraintBlockConstraint(newType, monitor, info);
                        part.setType(newType);
                    }
                    return CommandResult.newOKCommandResult((Object)part);
                }

                private void createConstraintBlockConstraint(Type newType, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)newType);
                    if (commandService != null) {
                        CreateElementRequest createTypeRequest = new CreateElementRequest((EObject)newType, (IElementType)UMLElementTypes.CONSTRAINT);
                        createTypeRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)(String.valueOf(newType.getName()) + "Specification")));
                        ICommand newConstraintCreateCommand = commandService.getEditCommand((IEditCommandRequest)createTypeRequest);
                        if (newConstraintCreateCommand.canExecute()) {
                            newConstraintCreateCommand.execute(monitor, info);
                        }
                    }
                }
            };
            configureCommand = CompositeCommand.compose((ICommand)configureCommand, (ICommand)setTypeCommand);
            return configureCommand;
        }
        return this.cancelCommand(request);
    }

    protected IDirectEditorConfiguration initExtendedEditorConfiguration(EObject element) {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + element.eClass().getInstanceClassName());
        IDirectEditorConfiguration configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)element.eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)element.eClass().getInstanceClassName());
        return configuration;
    }
}

