/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.command.Command;

public class MICommand
extends Command {
    static final String[] empty = new String[0];
    String[] fOptions = empty;
    String[] fParameters = empty;
    String fOperation = new String();
    String fMIVersion;

    public MICommand(String miVersion, String oper) {
        this(miVersion, oper, empty);
    }

    public MICommand(String miVersion, String oper, String[] params) {
        this(miVersion, oper, empty, params);
    }

    public MICommand(String miVersion, String oper, String[] opt, String[] params) {
        this.fMIVersion = miVersion;
        this.fOperation = oper;
        this.fOptions = opt;
        this.fParameters = params;
    }

    public String getMIVersion() {
        return this.fMIVersion;
    }

    public void setMIVersion(String miVersion) {
        this.fMIVersion = miVersion;
    }

    public boolean isMI1() {
        return "mi1".equalsIgnoreCase(this.fMIVersion);
    }

    public boolean isMI2() {
        return "mi2".equalsIgnoreCase(this.fMIVersion);
    }

    public String getOperation() {
        return this.fOperation;
    }

    protected void setOperation(String op) {
        this.fOperation = op;
    }

    public String[] getOptions() {
        return this.fOptions;
    }

    public void setOptions(String[] opt) {
        this.fOptions = opt;
    }

    public String[] getParameters() {
        return this.fParameters;
    }

    public void setParameters(String[] p) {
        this.fParameters = p;
    }

    protected String optionsToString() {
        String[] options = this.getOptions();
        StringBuffer sb = new StringBuffer();
        if (options != null && options.length > 0) {
            int i = 0;
            while (i < options.length) {
                String option = options[i];
                if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                    StringBuffer buf = new StringBuffer();
                    int j = 0;
                    while (j < option.length()) {
                        char c = option.charAt(j);
                        if (c == '\"' || c == '\\') {
                            buf.append('\\');
                        }
                        buf.append(c);
                        ++j;
                    }
                    option = buf.toString();
                }
                if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                    sb.append(' ').append('\"').append(option).append('\"');
                } else {
                    sb.append(' ').append(option);
                }
                ++i;
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        String[] parameters = this.getParameters();
        String[] options = this.getOptions();
        StringBuffer buffer = new StringBuffer();
        if (parameters != null && parameters.length > 0) {
            if (options != null && options.length > 0) {
                int i = 0;
                while (i < parameters.length) {
                    if (parameters[i].startsWith("-")) {
                        buffer.append('-').append('-');
                        break;
                    }
                    ++i;
                }
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < parameters.length) {
                sb.setLength(0);
                String param = parameters[i];
                int j = 0;
                while (j < param.length()) {
                    char c = param.charAt(j);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    ++j;
                }
                if (this.containsWhitespace(param)) {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
                buffer.append(' ').append(sb);
                ++i;
            }
        }
        return buffer.toString().trim();
    }

    public String toString() {
        String p;
        StringBuffer command = new StringBuffer(String.valueOf(this.getToken()) + this.getOperation());
        String opt = this.optionsToString();
        if (opt.length() > 0) {
            command.append(' ').append(opt);
        }
        if ((p = this.parametersToString()).length() > 0) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    protected boolean containsWhitespace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

