/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.widget.celleditors.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.emf.facet.widgets.celleditors.internal.core.NaryReferenceCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.StereotypePropertyUtils;
import org.eclipse.papyrus.uml.table.widget.celleditors.utils.StereotypePropertyFacetElementUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaryReferencePapyrusCellEditor<T extends EObject>
extends NaryReferenceCellEditor<T> {
    private MultipleValueSelectorDialog dialog;

    public Control activateCell(Composite parent, List<T> values, List<T> availableValues, final IModelCellEditHandler editHandler, EObject source, EStructuralFeature feature) {
        Collection coll;
        UMLContentProvider p;
        if (!(source instanceof Element)) {
            return super.activateCell(parent, values, availableValues, editHandler, source, feature);
        }
        final Composite placeholderComposite = new Composite(parent, 0);
        EObject realSource = StereotypePropertyFacetElementUtils.getRealSource(source, feature);
        EStructuralFeature realFeature = StereotypePropertyFacetElementUtils.getRealFeature(source, feature);
        if (feature instanceof StereotypePropertyElement) {
            assert (source instanceof Element);
            Stereotype ste = StereotypePropertyUtils.getAppliedStereotype((Element)((Element)source), (StereotypePropertyElement)((StereotypePropertyElement)feature));
            p = new UMLContentProvider(realSource, realFeature, ste, source.eResource().getResourceSet());
        } else {
            p = new UMLContentProvider(source, feature, null, source.eResource().getResourceSet());
        }
        String title = realFeature.getName();
        boolean unique = realFeature.isUnique();
        boolean ordered = realFeature.isOrdered();
        int upperBound = realFeature.getUpperBound();
        ReferenceSelector selector = new ReferenceSelector(unique);
        selector.setContentProvider((IStaticContentProvider)p);
        selector.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        Collection value = (Collection)realSource.eGet(realFeature);
        this.dialog = new MultipleValueSelectorDialog(Display.getCurrent().getActiveShell(), (IElementSelector)selector, title, unique, ordered, upperBound){

            protected void okPressed() {
                super.okPressed();
                editHandler.commit();
            }

            public boolean close() {
                placeholderComposite.dispose();
                return super.close();
            }
        };
        this.dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        if (value != null && value instanceof Collection && !(coll = value).isEmpty()) {
            this.dialog.setInitialSelections(coll.toArray());
        }
        this.dialog.open();
        return placeholderComposite;
    }

    public List<T> getValue() {
        if (this.dialog == null) {
            return super.getValue();
        }
        Object[] result = this.dialog.getResult();
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<EObject> values = new ArrayList<EObject>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object current = objectArray[n2];
            values.add((EObject)current);
            ++n2;
        }
        return values;
    }
}

