/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.widget.celleditors.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.IListener;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.emf.facet.widgets.celleditors.internal.core.UnaryReferenceCellEditor;
import org.eclipse.papyrus.infra.emf.utils.TransactionalUnsetter;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.StereotypePropertyUtils;
import org.eclipse.papyrus.uml.table.widget.celleditors.composite.UnaryReferencePapyrusCellEditorComposite;
import org.eclipse.papyrus.uml.table.widget.celleditors.utils.NoReferencedElement;
import org.eclipse.papyrus.uml.table.widget.celleditors.utils.StereotypePropertyFacetElementUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class UnaryReferencePapyrusCellEditor
extends UnaryReferenceCellEditor {
    private AbstractCellEditorComposite<EObject> cellEditorComposite;

    public Control activateCell(Composite parent, Object originalValue, final IModelCellEditHandler editHandler, EStructuralFeature feature, EObject source) {
        if (!(source instanceof Element)) {
            this.cellEditorComposite = (AbstractCellEditorComposite)super.activateCell(parent, originalValue, editHandler, feature, source);
        } else {
            UMLContentProvider p;
            final EStructuralFeature realFeature = StereotypePropertyFacetElementUtils.getRealFeature(source, feature);
            final EObject realSource = StereotypePropertyFacetElementUtils.getRealSource(source, feature);
            if (feature instanceof StereotypePropertyElement) {
                assert (source instanceof Element);
                Stereotype ste = StereotypePropertyUtils.getAppliedStereotype((Element)((Element)source), (StereotypePropertyElement)((StereotypePropertyElement)feature));
                p = new UMLContentProvider(realSource, realFeature, ste, source.eResource().getResourceSet());
            } else {
                p = new UMLContentProvider(source, feature, null, source.eResource().getResourceSet());
            }
            HierarchicToFlatContentProvider flatP = new HierarchicToFlatContentProvider((IHierarchicContentProvider)p);
            List<Object> list = Arrays.asList(flatP.getElements());
            ArrayList<EObject> availableValues = new ArrayList<EObject>();
            for (Object current : list) {
                if (!(current instanceof EObject)) continue;
                availableValues.add((EObject)current);
            }
            availableValues.add(0, (EObject)new NoReferencedElement("null"));
            this.cellEditorComposite = new UnaryReferencePapyrusCellEditorComposite(parent, availableValues, source, feature);
            this.cellEditorComposite.addCommitListener(new IListener(){

                public void handleEvent() {
                    EObject value = (EObject)UnaryReferencePapyrusCellEditor.this.cellEditorComposite.getValue();
                    if (value instanceof NoReferencedElement && !realFeature.isUnsettable()) {
                        TransactionalUnsetter unsetter = new TransactionalUnsetter(realSource, realFeature);
                        unsetter.doUnset();
                        UnaryReferencePapyrusCellEditor.this.cellEditorComposite.dispose();
                    } else {
                        editHandler.commit();
                    }
                }
            });
        }
        return this.cellEditorComposite;
    }

    public Object getValue() {
        Object selectedValue = this.cellEditorComposite.getValue();
        if (selectedValue instanceof NoReferencedElement) {
            return null;
        }
        return selectedValue;
    }
}

