/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OLDCompartmentFigure
extends NodeNamedElementFigure {
    private Map<String, RectangleFigure> containerFigures;
    private final List<String> compartmentID;
    private IFigure contentPane;
    private static final int MINIMUM_COMPARTMENT_HEIGHT = 15;

    public OLDCompartmentFigure(List<String> compartmentFigure) {
        this(compartmentFigure, null);
    }

    public OLDCompartmentFigure(List<String> compartmentFigure, String taggedLabelValue) {
        super(taggedLabelValue);
        this.setLayoutManager((LayoutManager)new CompartmentLayoutManager());
        this.setOpaque(true);
        this.compartmentID = compartmentFigure;
        this.createContentPane(compartmentFigure);
    }

    protected void createContentPane(List<String> compartmentFigure) {
        this.contentPane = new Figure();
        this.contentPane.setOpaque(false);
        this.add(this.contentPane);
        this.containerFigures = new HashMap<String, RectangleFigure>();
        for (String id : compartmentFigure) {
            RectangleFigure newFigure = new RectangleFigure();
            newFigure.setFill(false);
            newFigure.setBorder(null);
            newFigure.setOutline(false);
            this.contentPane.add((IFigure)newFigure);
            this.containerFigures.put(id, newFigure);
        }
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public RectangleFigure getCompartment(String id) {
        return this.containerFigures.get(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompartmentLayoutManager
    extends AbstractLayout {
        private static final int wrappedLabelSize = 18;

        private CompartmentLayoutManager() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            int minimumWith = 0;
            int minimumHeight = 0;
            if (OLDCompartmentFigure.this.getNameLabel() != null) {
                if (OLDCompartmentFigure.this.getNameLabel().getPreferredSize().width > minimumWith) {
                    minimumWith = OLDCompartmentFigure.this.getNameLabel().getPreferredSize().width;
                }
                minimumHeight += OLDCompartmentFigure.this.getNameLabel().getPreferredSize().height;
            }
            return new Dimension(minimumWith, minimumHeight);
        }

        public void layout(IFigure container) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < childrenList.size()) {
                Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                bound.setSize(((IFigure)childrenList.get(i)).getPreferredSize());
                bound.width = OLDCompartmentFigure.this.getBounds().width;
                bound.x = OLDCompartmentFigure.this.getBounds().x;
                bound.y = i > 0 ? ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1 : OLDCompartmentFigure.this.getBounds().y;
                ((IFigure)childrenList.get(i)).setBounds(bound);
                ++i;
            }
            HashMap<String, Dimension> compartmentsDimension = new HashMap<String, Dimension>(OLDCompartmentFigure.this.compartmentID.size());
            for (String compartment : OLDCompartmentFigure.this.compartmentID) {
                ResizableCompartmentFigure rcf;
                RectangleFigure rectangleFigure = (RectangleFigure)OLDCompartmentFigure.this.containerFigures.get(compartment);
                if (rectangleFigure.getChildren().size() <= 0 || (rcf = (ResizableCompartmentFigure)rectangleFigure.getChildren().get(0)) == null) continue;
                Dimension dimensionCompartment = this.getDimension(rcf);
                compartmentsDimension.put(compartment, dimensionCompartment);
            }
            this.optimizeCompartmentSize(compartmentsDimension);
            int i2 = 0;
            while (i2 < OLDCompartmentFigure.this.compartmentID.size()) {
                ResizableCompartmentFigure rcf;
                RectangleFigure rectangleFigure = (RectangleFigure)OLDCompartmentFigure.this.containerFigures.get(OLDCompartmentFigure.this.compartmentID.get(i2));
                if (rectangleFigure.getChildren().size() > 0 && (rcf = (ResizableCompartmentFigure)rectangleFigure.getChildren().get(0)) != null) {
                    Point point = this.getPosition(i2);
                    Rectangle rect = new Rectangle(point, compartmentsDimension.get(OLDCompartmentFigure.this.compartmentID.get(i2)));
                    rcf.getParent().setBounds(rect);
                    rcf.setBounds(rect);
                }
                ++i2;
            }
            OLDCompartmentFigure.this.contentPane.getBounds().setSize(OLDCompartmentFigure.this.getBounds().width, OLDCompartmentFigure.this.getBounds().y + OLDCompartmentFigure.this.getBounds().height - ((OLDCompartmentFigure)OLDCompartmentFigure.this).contentPane.getBounds().y);
        }

        private Dimension getDimension(ResizableCompartmentFigure rcf) {
            Dimension dimensionCompartment = new Dimension(OLDCompartmentFigure.this.getBounds().width, 0);
            if (rcf.isExpanded()) {
                dimensionCompartment.height += 18 * rcf.getContentPane().getChildren().size();
            }
            return dimensionCompartment;
        }

        private Point getPosition(int index) {
            Point point = new Point(OLDCompartmentFigure.this.getContentPane().getBounds().x, OLDCompartmentFigure.this.getContentPane().getBounds().y);
            if (index > 0) {
                RectangleFigure previousRectangle = (RectangleFigure)OLDCompartmentFigure.this.containerFigures.get(OLDCompartmentFigure.this.compartmentID.get(index - 1));
                ResizableCompartmentFigure rcf = (ResizableCompartmentFigure)previousRectangle.getChildren().get(0);
                point.y = rcf.getParent().getBounds().y + rcf.getParent().getBounds().height;
            }
            return point;
        }

        private void optimizeCompartmentSize(HashMap<String, Dimension> compartmentsDimension) {
            int compartmentsHeight = 0;
            for (Dimension dimension : compartmentsDimension.values()) {
                if (dimension.height == 0) {
                    compartmentsHeight += 15;
                    continue;
                }
                compartmentsHeight += dimension.height;
            }
            if (OLDCompartmentFigure.this.getContentPane().getBounds().height > 0) {
                double ratio = new Integer(compartmentsHeight).doubleValue() / new Integer(OLDCompartmentFigure.this.getContentPane().getBounds().height).doubleValue();
                for (Dimension dimension : compartmentsDimension.values()) {
                    dimension.height = (int)((double)dimension.height / ratio);
                    if (dimension.height != 0) continue;
                    dimension.height = 15;
                }
            }
        }
    }
}

