/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import com.google.common.base.Optional;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteFromModelCommandHandler
extends GraphicalCommandHandler
implements IHandler {
    private static final String DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY = "displayMessageForDeleteActionPreferenceKey";

    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Delete From Model");
        for (IGraphicalEditPart editPart : editParts) {
            Command curCommand;
            if (editPart instanceof DiagramEditPart || (curCommand = editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))) == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    protected boolean computeEnabled() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        IReadOnlyHandler readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
        for (IGraphicalEditPart editPart : this.getSelectedElements()) {
            Optional result;
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView((Object)editPart);
            if (readOnly == null) continue;
            LinkedList<URI> uris = new LinkedList<URI>();
            if (semantic == null || semantic == graphical) {
                return false;
            }
            if (semantic.eContainer() == null) {
                return false;
            }
            uris.add(EcoreUtil.getURI((EObject)semantic));
            if (graphical != null) {
                uris.add(EcoreUtil.getURI((EObject)graphical));
            }
            if (!(result = readOnly.anyReadOnly(uris.toArray(new URI[uris.size()]))).isPresent() || !((Boolean)result.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.canDoAction()) {
            return super.execute(event);
        }
        return null;
    }

    protected boolean canDoAction() {
        MessageDialogWithToggle toggle;
        int returnCode;
        String hideValue;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean contains = store.contains(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY);
        if (!contains) {
            store.setValue(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY, "never");
            store.setDefault(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY, "never");
        }
        return (hideValue = store.getString(DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY)).equals("always") || (returnCode = (toggle = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Delete Action", (String)"WARNING! The Shorcuts for Hide and Delete actions have changed. \n \n Do you really want to delete an element of the model?", (String)"Don't show this dialog the next time", (boolean)false, (IPreferenceStore)store, (String)DISPLAY_MESSAGE_FOR_DELETE_ACTION_PREFERENCE_KEY)).getReturnCode()) == 2;
    }
}

