/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class FullInsidePortPositionLocator
extends PortPositionLocator {
    private int insidePortSize = 20;
    private int corner = 0;

    public FullInsidePortPositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
        this.borderItemOffset = 0;
    }

    public FullInsidePortPositionLocator(IFigure parentFigure, int preferredSide, int corner) {
        this(parentFigure, preferredSide);
        this.corner = corner;
    }

    public FullInsidePortPositionLocator(IFigure parentFigure, int preferredSide, int corner, int portSize) {
        this(parentFigure, preferredSide, corner);
        this.insidePortSize = portSize;
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        int offSetX;
        int h;
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x;
        int xMax = parentRec.x + parentRec.width - this.insidePortSize;
        int yMin = parentRec.y;
        int yMax = parentRec.y + parentRec.height - this.insidePortSize;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        if (realLocation.y != yMin && realLocation.y != yMax && realLocation.x != xMin && realLocation.x != xMax) {
            realLocation.x = realLocation.x <= xMin + parentRec.width / 2 ? xMin : xMax;
        }
        if (realLocation.x > xMax - this.corner / 2) {
            if (realLocation.y < yMin + this.corner / 2) {
                h = yMin + this.corner / 2 - realLocation.y;
                offSetX = new Double(Math.sqrt(Math.pow(this.corner / 2, 2.0) - Math.pow(h, 2.0))).intValue();
                realLocation.x = xMax - this.corner / 2 + offSetX;
            }
            if (realLocation.y > yMax - this.corner / 2) {
                h = realLocation.y - (yMax - this.corner / 2);
                offSetX = new Double(Math.sqrt(Math.pow(this.corner / 2, 2.0) - Math.pow(h, 2.0))).intValue();
                realLocation.x = xMax - this.corner / 2 + offSetX;
            }
        }
        if (realLocation.x < xMin + this.corner / 2 && (realLocation.y < yMin + this.corner / 2 || realLocation.y > yMax - this.corner / 2)) {
            if (realLocation.y < yMin + this.corner / 2) {
                h = yMin + this.corner / 2 - realLocation.y;
                offSetX = new Double(Math.sqrt(Math.pow(this.corner / 2, 2.0) - Math.pow(h, 2.0))).intValue();
                realLocation.x = xMin + this.corner / 2 - offSetX;
            }
            if (realLocation.y > yMax - this.corner / 2) {
                h = realLocation.y - (yMax - this.corner / 2);
                offSetX = new Double(Math.sqrt(Math.pow(this.corner / 2, 2.0) - Math.pow(h, 2.0))).intValue();
                realLocation.x = xMin + this.corner / 2 - offSetX;
            }
        }
        return realLocation;
    }
}

