/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.utils.PapyrusTrace;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.IPaletteDescription;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.common.service.IProfileDependantPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.PapyrusPaletteService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteUtil {
    public static PaletteContainer getContainerByID(PaletteContainer container, String parentID) {
        if (parentID.equals(container.getId())) {
            return container;
        }
        Iterator<PaletteContainer> it = PaletteUtil.getDirectChildContainers(container).iterator();
        while (it.hasNext()) {
            PaletteContainer tmp = PaletteUtil.getContainerByID(it.next(), parentID);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    public static EClass getToolMetaclass(ToolEntry entry) {
        Tool tool = entry.createTool();
        List<IElementType> types = null;
        if (tool instanceof AspectUnspecifiedTypeCreationTool) {
            types = ((AspectUnspecifiedTypeCreationTool)tool).getElementTypes();
        } else if (tool instanceof AspectUnspecifiedTypeConnectionTool) {
            types = ((AspectUnspecifiedTypeConnectionTool)tool).getElementTypes();
        }
        if (types != null && types.size() > 0) {
            IElementType type = types.get(0);
            if (type instanceof SpecializationType) {
                type = ((SpecializationType)type).getSpecializedTypes()[0];
            }
            return type.getEClass();
        }
        return null;
    }

    public static PaletteContainer getContainerByID(PaletteEntry entry, String parentID) {
        PaletteContainer root = PaletteUtil.getRoot(entry);
        return PaletteUtil.getContainerByID(root, parentID);
    }

    public static List<PaletteContainer> getDirectChildContainers(PaletteContainer container) {
        ArrayList<PaletteContainer> containers = new ArrayList<PaletteContainer>();
        for (PaletteEntry entry : container.getChildren()) {
            if (!(entry instanceof PaletteContainer)) continue;
            containers.add((PaletteContainer)entry);
        }
        return containers;
    }

    public static PaletteContainer getRoot(PaletteContainer container) {
        if (container.getParent() != null) {
            return PaletteUtil.getRoot(container.getParent());
        }
        return container;
    }

    public static PaletteContainer getRoot(PaletteEntry entry) {
        return PaletteUtil.getRoot(entry.getParent());
    }

    private PaletteUtil() {
    }

    public static List<ToolEntry> getAllToolEntries(PaletteContainer container) {
        ArrayList<ToolEntry> entries = new ArrayList<ToolEntry>();
        for (PaletteEntry entry : container.getChildren()) {
            if (entry instanceof ToolEntry) {
                entries.add((ToolEntry)entry);
            }
            if (!(entry instanceof PaletteContainer)) continue;
            entries.addAll(PaletteUtil.getAllToolEntries((PaletteContainer)entry));
        }
        return entries;
    }

    public static IMemento getMemento(IMemento rootMemento, String id) {
        IMemento memento = null;
        memento = rootMemento.getChild(id);
        return memento;
    }

    public static List<PaletteEntry> getAllEntries(PaletteContainer container) {
        ArrayList<PaletteEntry> elements = new ArrayList<PaletteEntry>();
        for (Object object : container.getChildren()) {
            if (object instanceof PaletteContainer) {
                elements.add((PaletteEntry)((PaletteContainer)object));
                elements.addAll(PaletteUtil.getAllEntries((PaletteContainer)object));
                continue;
            }
            if (!(object instanceof ToolEntry)) continue;
            elements.add((PaletteEntry)((ToolEntry)object));
        }
        return elements;
    }

    public static Set<? extends PaletteEntry> getAvailableEntries(IEditorPart part, ProviderPriority priority) {
        HashSet entries = new HashSet();
        PaletteRoot root = new PaletteRoot();
        List<? extends Service.ProviderDescriptor> providers = PapyrusPaletteService.getInstance().getProviders();
        ContributeToPaletteOperation operation = new ContributeToPaletteOperation(part, (Object)part.getEditorInput(), root, new HashMap());
        List<? extends Service.ProviderDescriptor> providerList = PapyrusPaletteService.getInstance().getProviders();
        for (PapyrusPaletteService.ProviderDescriptor providerDescriptor : providerList) {
            int compare = providerDescriptor.getPriority().compareTo((Object)priority);
            if (compare >= 0 || !providerDescriptor.providesWithVisibility(operation)) continue;
            ((IPaletteProvider)providerDescriptor.getProvider()).contributeToPalette(part, (Object)part.getEditorInput(), root, new HashMap());
        }
        return entries;
    }

    public static Map<String, PaletteEntry> getAvailableEntriesSet(IEditorPart part, ProviderPriority priority) {
        HashMap<String, PaletteEntry> entries = new HashMap<String, PaletteEntry>();
        PaletteRoot root = new PaletteRoot();
        List<? extends Service.ProviderDescriptor> providers = PapyrusPaletteService.getInstance().getProviders();
        ContributeToPaletteOperation operation = new ContributeToPaletteOperation(part, (Object)part.getEditorInput(), root, entries);
        List<? extends Service.ProviderDescriptor> providerList = PapyrusPaletteService.getInstance().getProviders();
        for (PapyrusPaletteService.ProviderDescriptor providerDescriptor : providerList) {
            int compare = providerDescriptor.getPriority().compareTo((Object)priority);
            if (compare > 0 || !providerDescriptor.providesWithVisibility(operation)) continue;
            ((IPaletteProvider)providerDescriptor.getProvider()).contributeToPalette(part, (Object)part.getEditorInput(), root, entries);
        }
        return entries;
    }

    public static List<String> getStereotypeListFromString(String serializedForm) {
        StringTokenizer tokenizer = new StringTokenizer(serializedForm, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    public static String getSerializedStereotypeList(Collection<String> stereotypes) {
        return PaletteUtil.convertToCommaSeparatedRepresentation(stereotypes);
    }

    public static String findProfileNameFromStereotypeName(String stereotypeName) {
        return stereotypeName.substring(0, stereotypeName.lastIndexOf("::"));
    }

    public static String getSerializedProfileList(Collection<String> profiles) {
        return PaletteUtil.convertToCommaSeparatedRepresentation(profiles);
    }

    public static String convertToCommaSeparatedRepresentation(Collection objects) {
        return PaletteUtil.convertToFlatRepresentation(objects, ",");
    }

    public static String convertToFlatRepresentation(Collection objects, String separator) {
        StringBuilder buffer = new StringBuilder();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static Set<String> getProfileSetFromString(String serializedForm) {
        StringTokenizer tokenizer = new StringTokenizer(serializedForm, ",");
        HashSet<String> list = new HashSet<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static boolean areRequiredProfileApplied(IEditorPart part, PapyrusPaletteService.ProviderDescriptor papyrusProviderDesc) {
        if (!(part instanceof DiagramEditorWithFlyOutPalette)) {
            PapyrusTrace.log((int)2, (String)"trying to check a papyrus palette descriptor outside papyrus framework");
            return false;
        }
        if (papyrusProviderDesc instanceof PapyrusPaletteService.LocalProviderDescriptor) {
            IPaletteDescription description = ((PapyrusPaletteService.LocalProviderDescriptor)papyrusProviderDesc).getDescription();
            Diagram diagram = ((DiagramEditorWithFlyOutPalette)part).getDiagram();
            EObject element = diagram.getElement();
            if (element instanceof Element) {
                String requiredProfilesList;
                Package package_ = ((Element)element).getNearestPackage();
                EList appliedProfiles = package_.getAllAppliedProfiles();
                ArrayList<String> appliedProfilesNames = new ArrayList<String>();
                for (Profile profile : appliedProfiles) {
                    appliedProfilesNames.add(profile.getQualifiedName());
                }
                Map<String, String> properties = description.getProperties();
                if (description != null && (requiredProfilesList = properties.get("requiredProfiles")) != null) {
                    Set<String> requiredProfiles = PaletteUtil.getProfileSetFromString(requiredProfilesList);
                    for (String requiredProfileName : requiredProfiles) {
                        if (appliedProfilesNames.contains(requiredProfileName)) continue;
                        return false;
                    }
                }
            }
        } else {
            IProvider provider = papyrusProviderDesc.getProvider();
            if (provider instanceof IProfileDependantPaletteProvider) {
                Diagram diagram = ((DiagramEditorWithFlyOutPalette)part).getDiagram();
                EObject element = diagram.getElement();
                if (element instanceof Element) {
                    Package package_ = ((Element)element).getNearestPackage();
                    EList appliedProfiles = package_.getAllAppliedProfiles();
                    ArrayList<String> appliedProfilesNames = new ArrayList<String>();
                    for (Profile profile : appliedProfiles) {
                        appliedProfilesNames.add(profile.getQualifiedName());
                    }
                    Collection<String> requiredProfiles = ((IProfileDependantPaletteProvider)provider).getRequiredProfiles();
                    for (String requiredProfileName : requiredProfiles) {
                        if (appliedProfilesNames.contains(requiredProfileName)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static void initAspectActions(NodeList aspectActionNodes, List<IPostAction> postActions, List<IPreAction> preActions) {
        int i = 0;
        while (i < aspectActionNodes.getLength()) {
            IAspectAction action;
            IAspectActionProvider provider;
            Node childNode = aspectActionNodes.item(i);
            String childName = childNode.getNodeName();
            if ("postAction".equals(childName)) {
                provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                if (provider != null) {
                    action = provider.createAction(childNode);
                    if (action instanceof IPostAction) {
                        postActions.add((IPostAction)action);
                    }
                } else {
                    Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                }
            } else if ("preAction".equals(childName)) {
                provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                if (provider != null) {
                    action = provider.createAction(childNode);
                    if (action instanceof IPreAction) {
                        preActions.add((IPreAction)action);
                    }
                } else {
                    Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                }
            }
            ++i;
        }
    }
}

