/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotResourceValidator
extends ResourceValidatorImpl {
    private static final Logger log = Logger.getLogger(PivotResourceValidator.class);
    public static final String HAS_SYNTAX_ERRORS = "has_syntax_errors";

    protected ValidationDiagnostic createDefaultDiagnostic(Diagnostician diagnostician, EObject pivotObject) {
        return new ValidationDiagnostic();
    }

    protected void issueFromDiagnostics(IAcceptor<Issue> acceptor, ValidationDiagnostic diagnostic) {
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
        }
    }

    protected void performValidation(IAcceptor<Issue> acceptor, Resource pivotResource, CancelIndicator monitor) {
        Diagnostician diagnostician = this.getDiagnostician();
        Map context = diagnostician.createDefaultContext();
        EList resources = pivotResource.getResourceSet().getResources();
        int i = 0;
        while (i < resources.size()) {
            Resource pResource = (Resource)resources.get(i);
            this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getErrors());
            this.removeValidationDiagnostics((List<Resource.Diagnostic>)pResource.getWarnings());
            for (EObject pObject : pResource.getContents()) {
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ValidationDiagnostic diagnostic = this.createDefaultDiagnostic(diagnostician, pObject);
                    diagnostician.validate(pObject, (DiagnosticChain)diagnostic, context);
                    if (diagnostic.getChildren().isEmpty()) continue;
                    if (diagnostic.getSeverity() == 4) {
                        pResource.getErrors().add((Object)diagnostic);
                    } else if (diagnostic.getSeverity() == 2) {
                        pResource.getWarnings().add((Object)diagnostic);
                    }
                    this.issueFromDiagnostics(acceptor, diagnostic);
                }
                catch (RuntimeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void removeValidationDiagnostics(List<Resource.Diagnostic> diagnostics) {
        int i = diagnostics.size() - 1;
        while (i >= 0) {
            Resource.Diagnostic diagnostic = diagnostics.get(i);
            if (diagnostic instanceof ValidationDiagnostic) {
                diagnostics.remove(i);
            }
            --i;
        }
    }

    protected void reuseValidation(IAcceptor<Issue> acceptor, Resource pivotResource, CancelIndicator monitor) {
        for (Resource pResource : pivotResource.getResourceSet().getResources()) {
            for (Resource.Diagnostic diagnostic : pResource.getErrors()) {
                if (!(diagnostic instanceof ValidationDiagnostic)) continue;
                this.issueFromDiagnostics(acceptor, (ValidationDiagnostic)diagnostic);
            }
            for (Resource.Diagnostic diagnostic : pResource.getWarnings()) {
                if (!(diagnostic instanceof ValidationDiagnostic)) continue;
                this.issueFromDiagnostics(acceptor, (ValidationDiagnostic)diagnostic);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) {
        Resource pivotResource;
        BaseCSResource csResource;
        CS2PivotResourceAdapter cs2pivotAdapter;
        CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
        this.resolveProxies(resource, monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(resource.getErrors().size() + resource.getWarnings().size()));
        try {
            IAcceptor acceptor = this.createAcceptor(result);
            if (mode.shouldCheck(CheckType.FAST)) {
                int i = 0;
                while (i < resource.getErrors().size()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
                    ++i;
                }
                i = 0;
                while (i < resource.getWarnings().size()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return null;
            }
            boolean syntaxDiagFail = !result.isEmpty();
            this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
            for (EObject ele : resource.getContents()) {
                try {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    HashMap options = Maps.newHashMap();
                    options.put("check.mode", mode);
                    options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
                    options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
                    options.put(EValidator.class, this.getDiagnostician());
                    boolean hasSyntaxError = false;
                    if (resource instanceof XtextResource) {
                        BaseCSResource csResource2;
                        EList errors;
                        options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
                        if (resource instanceof BaseCSResource && (hasSyntaxError = ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)(errors = (csResource2 = (BaseCSResource)resource).getErrors())))) {
                            options.put(HAS_SYNTAX_ERRORS, Boolean.TRUE);
                        }
                    }
                    if (hasSyntaxError) continue;
                    Diagnostic diagnostic = this.getDiagnostician().validate(ele, (Map)options);
                    if (!diagnostic.getChildren().isEmpty()) {
                        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                        }
                        continue;
                    }
                    this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
                }
                catch (RuntimeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (resource instanceof BaseCSResource && (cs2pivotAdapter = CS2PivotResourceAdapter.findAdapter(csResource = (BaseCSResource)resource)) != null && (pivotResource = cs2pivotAdapter.getPivotResource(csResource)) != null) {
            IAcceptor acceptor = this.createAcceptor(result);
            if (mode.shouldCheck(CheckType.EXPENSIVE)) {
                this.performValidation((IAcceptor<Issue>)acceptor, pivotResource, monitor);
            } else {
                this.reuseValidation((IAcceptor<Issue>)acceptor, pivotResource, monitor);
            }
        }
        return result;
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI()));
        }
    }

    public static class ValidationDiagnostic
    extends BasicDiagnostic
    implements Resource.Diagnostic {
        private ValidationDiagnostic() {
            super("org.eclipse.emf.ecore", 0, "", null);
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }

        public String getLocation() {
            return null;
        }

        public Integer getOffset() {
            return null;
        }

        public Integer getLength() {
            return 10;
        }
    }
}

