/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;

public class DeleteProfileFacetSetAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject objectToDestroy = request.getElementToDestroy();
        if (objectToDestroy == null) {
            return null;
        }
        if (objectToDestroy instanceof TableInstance2) {
            final TableInstance2 instance = (TableInstance2)objectToDestroy;
            final ArrayList rootFacetSetToDestroy = new ArrayList();
            final HashSet querySetToDestroy = new HashSet();
            ArrayList allStereotypeFacetsUsedInTheTable = new ArrayList();
            allStereotypeFacetsUsedInTheTable.addAll(instance.getFacets2());
            HashSet<FacetSet> rootFacetSets = new HashSet<FacetSet>();
            final HashSet<EPackage> rootPackages = new HashSet<EPackage>();
            for (Facet facet : allStereotypeFacetsUsedInTheTable) {
                if (!(facet instanceof StereotypeFacet)) continue;
                EObject container = facet.eContainer();
                while (container.eContainer() != null && container.eContainer() instanceof FacetSet) {
                    container = container.eContainer();
                }
                assert (container instanceof FacetSet);
                EObject rootPackage = container.eContainer();
                if (rootPackage == null) continue;
                assert (rootPackage instanceof EPackage && rootPackage.eContainer() == null);
                rootFacetSets.add((FacetSet)container);
                rootPackages.add((EPackage)rootPackage);
            }
            if (rootFacetSets.size() != 0) {
                final TransactionalEditingDomain domain = request.getEditingDomain();
                AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, "Destroy ProfileFacetSet Command", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        DestroyElementRequest destroyRequest;
                        IElementEditService provider;
                        ArrayList<EPackage> epackageToDestroy = new ArrayList<EPackage>();
                        for (EPackage currentRoot : rootPackages) {
                            for (EObject current : currentRoot.eContents()) {
                                if (!(current instanceof FacetSet) || DeleteProfileFacetSetAdvice.this.isUsed((TableInstance)instance, (FacetSet)current)) continue;
                                rootFacetSetToDestroy.add((FacetSet)current);
                                ModelQuerySet querySet = DeleteProfileFacetSetAdvice.this.getQuerySet((FacetSet)current);
                                if (querySet == null) continue;
                                querySetToDestroy.add(querySet);
                            }
                            ArrayList currentContents = new ArrayList(currentRoot.eContents());
                            currentContents.removeAll(rootFacetSetToDestroy);
                            if (!currentContents.isEmpty()) continue;
                            epackageToDestroy.add(currentRoot);
                        }
                        CompositeCommand destroyCommand = new CompositeCommand("Destroy ProfileFacetSet command");
                        for (EObject element : querySetToDestroy) {
                            provider = ElementEditServiceUtils.getCommandProvider((Object)element);
                            destroyRequest = new DestroyElementRequest(element, false);
                            destroyCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)destroyRequest));
                        }
                        for (EObject element : rootFacetSetToDestroy) {
                            provider = ElementEditServiceUtils.getCommandProvider((Object)element);
                            destroyRequest = new DestroyElementRequest(element, false);
                            destroyCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)destroyRequest));
                        }
                        for (EPackage ePackage : epackageToDestroy) {
                            provider = ElementEditServiceUtils.getCommandProvider((Object)ePackage);
                            destroyRequest = new DestroyElementRequest((EObject)ePackage, false);
                            destroyCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)destroyRequest));
                        }
                        if (!destroyCommand.isEmpty()) {
                            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)destroyCommand));
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                return cmd;
            }
        }
        return null;
    }

    protected boolean isUsed(TableInstance deletedTableInstance, FacetSet facetSet) {
        boolean isUsed = false;
        for (Facet facet : facetSet.getFacets()) {
            ECrossReferenceAdapter crossReferencerAdapter = CrossReferenceAdapter.getCrossReferenceAdapter((Notifier)facet);
            Collection settings = crossReferencerAdapter.getNonNavigableInverseReferences((EObject)facet, true);
            Iterator iterator = settings.iterator();
            while (iterator.hasNext() && !isUsed) {
                EStructuralFeature.Setting current = (EStructuralFeature.Setting)iterator.next();
                EObject object = current.getEObject();
                EStructuralFeature feature = current.getEStructuralFeature();
                if (object == deletedTableInstance && (feature == TableinstancePackage.eINSTANCE.getTableInstance_Facets() || feature == Tableinstance2Package.eINSTANCE.getTableInstance2_Facets2())) continue;
                isUsed = true;
            }
        }
        if (!isUsed) {
            for (EPackage subPackage : facetSet.getESubpackages()) {
                if (!(subPackage instanceof FacetSet) || isUsed) continue;
                isUsed = this.isUsed(deletedTableInstance, (FacetSet)subPackage);
            }
        }
        return isUsed;
    }

    protected ModelQuerySet getQuerySet(FacetSet facetset) {
        ModelQuerySet querySet = null;
        TreeIterator iterator = facetset.eAllContents();
        while (iterator.hasNext() && querySet == null) {
            EObject current = (EObject)iterator.next();
            if (!(current instanceof FacetStructuralFeature)) continue;
            ModelQuery modelQuery = ((FacetStructuralFeature)current).getValueQuery();
            querySet = modelQuery.getModelQuerySet();
        }
        return querySet;
    }
}

