/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.utils;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionUtils;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class StereotypePropertyUtils {
    private StereotypePropertyUtils() {
    }

    public static final Property findRealStereotypeProperty(Namespace namespace, StereotypePropertyElement el) {
        String propertyQualifiedName = el.getPropertyQualifiedName();
        for (Profile profile : namespace.getNearestPackage().getAllAppliedProfiles()) {
            List properties = NameResolutionUtils.getNamedElements((String)propertyQualifiedName, (Namespace)profile, (EClass)UMLPackage.eINSTANCE.getProperty());
            if (properties.size() != 1) continue;
            return (Property)properties.get(0);
        }
        return null;
    }

    public static final EStructuralFeature getEStructuralFeature(Element stereotypedElement, StereotypePropertyElement el) {
        EObject stereotypeApplication = StereotypePropertyUtils.getStereotypeApplication(stereotypedElement, el);
        if (stereotypeApplication != null) {
            String propertyQN = el.getPropertyQualifiedName();
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            return stereotypeApplication.eClass().getEStructuralFeature(propertyName);
        }
        return null;
    }

    public static final EObject getStereotypeApplication(Element stereotypedElement, StereotypePropertyElement el) {
        return StereotypePropertyUtils.getStereotypeApplication(stereotypedElement, (StereotypeFacet)el.eContainer());
    }

    public static final EObject getStereotypeApplication(Element stereotypedElement, StereotypeFacet facet) {
        String steQN = facet.getStereotypeQualifiedName();
        Stereotype ste = StereotypePropertyUtils.getAppliedStereotype(stereotypedElement, steQN);
        if (ste != null) {
            return stereotypedElement.getStereotypeApplication(ste);
        }
        return null;
    }

    public static final Stereotype getAppliedStereotype(Element el, String stereotypeQN) {
        Stereotype appliedStereotype = el.getAppliedStereotype(stereotypeQN);
        if (appliedStereotype != null) {
            return appliedStereotype;
        }
        if (appliedStereotype == null) {
            for (Stereotype appliedSte : el.getAppliedStereotypes()) {
                List superClasses = StereotypeUtil.getAllSuperStereotypes((Stereotype)appliedSte);
                for (Stereotype current : superClasses) {
                    if (!current.getQualifiedName().equals(stereotypeQN)) continue;
                    return appliedSte;
                }
            }
        }
        return null;
    }

    public static final Stereotype getAppliedStereotype(Element el, StereotypeFacet facet) {
        return StereotypePropertyUtils.getAppliedStereotype(el, facet.getStereotypeQualifiedName());
    }

    public static final Stereotype getAppliedStereotype(Element el, StereotypePropertyElement facetElement) {
        return StereotypePropertyUtils.getAppliedStereotype(el, (StereotypeFacet)facetElement.eContainer());
    }
}

