/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.part;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.uml.diagram.component.part.Messages;
import org.eclipse.papyrus.uml.diagram.component.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.component.part.UMLDiagramEditorUtil;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLMarkerNavigationProvider;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLValidationProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateAction
extends Action {
    private IWorkbenchPage page;

    public ValidateAction(IWorkbenchPage page) {
        this.setText(Messages.ValidateActionMessage);
        this.page = page;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.page.getActivePart();
        if (workbenchPart instanceof IDiagramWorkbenchPart) {
            final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
            try {
                new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        ValidateAction.runValidation(part.getDiagramEditPart(), (View)part.getDiagram());
                    }
                }).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
            }
        }
    }

    public static void runValidation(View view) {
        try {
            if (UMLDiagramEditorUtil.openDiagram(view.eResource())) {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart instanceof IDiagramWorkbenchPart) {
                    ValidateAction.runValidation(((IDiagramWorkbenchPart)editorPart).getDiagramEditPart(), view);
                } else {
                    ValidateAction.runNonUIValidation(view);
                }
            }
        }
        catch (Exception e) {
            UMLDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
        }
    }

    public static void runNonUIValidation(View view) {
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(view.getDiagram());
        ValidateAction.runValidation(diagramEditPart, view);
    }

    public static void runValidation(DiagramEditPart diagramEditPart, View view) {
        final DiagramEditPart fpart = diagramEditPart;
        final View fview = view;
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)view);
        UMLValidationProvider.runWithConstraints(txDomain, new Runnable(){

            public void run() {
                ValidateAction.validate(fpart, fview);
            }
        });
    }

    private static Diagnostic runEMFValidator(View target) {
        if (target.isSetElement() && target.getElement() != null) {
            return new Diagnostician(){

                public String getObjectLabel(EObject eObject) {
                    return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
                }
            }.validate(target.getElement());
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static void validate(DiagramEditPart diagramEditPart, View view) {
        IFile target;
        IFile iFile = target = view.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)view.eResource()) : null;
        if (target != null) {
            UMLMarkerNavigationProvider.deleteMarkers((IResource)target);
        }
        Diagnostic diagnostic = ValidateAction.runEMFValidator(view);
        ValidateAction.createMarkers(target, diagnostic, diagramEditPart);
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        if (view.isSetElement() && view.getElement() != null) {
            IStatus status = validator.validate(view.getElement());
            ValidateAction.createMarkers(target, status, diagramEditPart);
        }
    }

    private static void createMarkers(IFile target, IStatus validationStatus, DiagramEditPart diagramEditPart) {
        if (validationStatus.isOK()) {
            return;
        }
        IStatus rootStatus = validationStatus;
        ArrayList allStatuses = new ArrayList();
        UMLDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new UMLDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet<EObject>(), allStatuses));
        for (IConstraintStatus nextStatus : allStatuses) {
            View view = UMLDiagramEditorUtil.findView(diagramEditPart, nextStatus.getTarget(), element2ViewMap);
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment((EObject)view), EMFCoreUtil.getQualifiedName((EObject)nextStatus.getTarget(), (boolean)true), nextStatus.getMessage(), nextStatus.getSeverity());
        }
    }

    private static void createMarkers(IFile target, Diagnostic emfValidationStatus, DiagramEditPart diagramEditPart) {
        if (emfValidationStatus.getSeverity() == 0) {
            return;
        }
        Diagnostic rootStatus = emfValidationStatus;
        ArrayList allDiagnostics = new ArrayList();
        UMLDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new UMLDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet<EObject>(), allDiagnostics));
        for (Diagnostic nextDiagnostic : emfValidationStatus.getChildren()) {
            List data = nextDiagnostic.getData();
            if (data == null || data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
            EObject element = (EObject)data.get(0);
            View view = UMLDiagramEditorUtil.findView(diagramEditPart, element, element2ViewMap);
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment((EObject)view), EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true), nextDiagnostic.getMessage(), ValidateAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
        }
    }

    private static void addMarker(EditPartViewer viewer, IFile target, String elementId, String location, String message, int statusSeverity) {
        if (target == null) {
            return;
        }
        UMLMarkerNavigationProvider.addMarker(target, elementId, location, message, statusSeverity);
    }

    private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
        if (diagnosticSeverity == 0) {
            return 0;
        }
        if (diagnosticSeverity == 1) {
            return 1;
        }
        if (diagnosticSeverity == 2) {
            return 2;
        }
        if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
            return 4;
        }
        return 1;
    }

    private static Set<EObject> collectTargetElements(IStatus status, Set<EObject> targetElementCollector, List allConstraintStatuses) {
        if (status instanceof IConstraintStatus) {
            targetElementCollector.add(((IConstraintStatus)status).getTarget());
            allConstraintStatuses.add(status);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                ValidateAction.collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);
                ++i;
            }
        }
        return targetElementCollector;
    }

    private static Set<EObject> collectTargetElements(Diagnostic diagnostic, Set<EObject> targetElementCollector, List allDiagnostics) {
        List data = diagnostic.getData();
        EObject target = null;
        if (data != null && !data.isEmpty() && data.get(0) instanceof EObject) {
            target = (EObject)data.get(0);
            targetElementCollector.add(target);
            allDiagnostics.add(diagnostic);
        }
        if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {
            Iterator it = diagnostic.getChildren().iterator();
            while (it.hasNext()) {
                ValidateAction.collectTargetElements((Diagnostic)it.next(), targetElementCollector, allDiagnostics);
            }
        }
        return targetElementCollector;
    }
}

