/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.common.label;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.common.label.DefaultLabelGeneratorBuilder;
import org.eclipse.ocl.examples.common.label.ILabelGenerator;
import org.eclipse.ocl.examples.common.label.generators.ENamedElementLabelGenerator;
import org.eclipse.ocl.examples.common.label.generators.EObjectLabelGenerator;
import org.eclipse.ocl.examples.common.label.generators.EcoreURILabelGenerator;
import org.eclipse.ocl.examples.common.label.generators.StringLabelGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelGeneratorRegistry
implements ILabelGenerator.Registry {
    protected final ILabelGenerator.Registry delegate;
    private final Map<Class<?>, Object> map = new HashMap();

    public static String debugLabelFor(Object object) {
        HashMap options = new HashMap();
        options.put(ILabelGenerator.Builder.SHOW_CLASS_SIMPLE_NAME, Boolean.TRUE);
        DefaultLabelGeneratorBuilder result = new DefaultLabelGeneratorBuilder(INSTANCE, options);
        result.buildLabelFor(object);
        return ((Object)result).toString();
    }

    public static void initialize(ILabelGenerator.Registry registry) {
        ENamedElementLabelGenerator.initialize(registry);
        EObjectLabelGenerator.initialize(registry);
        EcoreURILabelGenerator.initialize(registry);
        StringLabelGenerator.initialize(registry);
    }

    public LabelGeneratorRegistry() {
        this.delegate = null;
    }

    public LabelGeneratorRegistry(ILabelGenerator.Registry delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> void buildLabelFor(ILabelGenerator.Builder s, T labelledObject) {
        if (labelledObject == null) {
            s.appendString("<null-Object>");
            return;
        }
        Boolean showClassName = s.getOption(ILabelGenerator.Builder.SHOW_CLASS_NAME);
        if (showClassName != null && showClassName.booleanValue()) {
            s.appendString(labelledObject.getClass().getName());
            s.appendString(" ");
        } else {
            Boolean showClassSimpleName = s.getOption(ILabelGenerator.Builder.SHOW_CLASS_SIMPLE_NAME);
            if (showClassSimpleName != null && showClassSimpleName.booleanValue()) {
                s.appendString(labelledObject.getClass().getSimpleName());
                s.appendString(" ");
            }
        }
        if (labelledObject instanceof ILabelGenerator.Self) {
            ((ILabelGenerator.Self)labelledObject).buildLabel(s);
            return;
        }
        this.buildSubLabelFor(s, labelledObject);
    }

    @Override
    public <T> void buildSubLabelFor(ILabelGenerator.Builder labelBuilder, T labelledObject) {
        if (labelledObject == null) {
            labelBuilder.appendString("<null-Object>");
            return;
        }
        ILabelGenerator<?> labelGenerator = this.get(labelledObject.getClass());
        if (labelGenerator == null && (labelGenerator = this.getLabelGenerator(labelledObject.getClass())) != null) {
            this.install(labelledObject.getClass(), labelGenerator);
        }
        if (labelGenerator != null) {
            ILabelGenerator<?> castLabelGenerator = labelGenerator;
            castLabelGenerator.buildLabelFor(labelBuilder, labelledObject);
            return;
        }
        this.getLabelGenerator(labelledObject.getClass());
        labelBuilder.appendString("<unknown-");
        labelBuilder.appendString(labelledObject.getClass().getSimpleName());
        labelBuilder.appendString(" ");
        labelBuilder.appendString(labelledObject.toString());
        labelBuilder.appendString(">");
    }

    public ILabelGenerator.Builder createDefaultLabelBuilder(Map<ILabelGenerator.Option<?>, Object> options) {
        return new DefaultLabelGeneratorBuilder(this, options);
    }

    @Override
    public ILabelGenerator<?> get(Class<?> labelledClass) {
        ILabelGenerator<?> object = this.map.get(labelledClass);
        if (object instanceof ILabelGenerator.Descriptor) {
            object = ((ILabelGenerator.Descriptor)((Object)object)).getLabelGenerator();
            this.map.put(labelledClass, object);
        }
        if (object != null) {
            return object;
        }
        if (this.delegate != null) {
            return this.delegate.get(labelledClass);
        }
        return null;
    }

    protected ILabelGenerator<?> getLabelGenerator(Class<?> cls) {
        ILabelGenerator<?> labelGenerator;
        Class<?> iCls;
        Class<?> sCls = cls;
        while (sCls != null) {
            ILabelGenerator<?> labelGenerator2 = this.get(sCls);
            if (labelGenerator2 != null) {
                return labelGenerator2;
            }
            sCls = sCls.getSuperclass();
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            labelGenerator = this.get(iCls);
            if (labelGenerator != null) {
                return labelGenerator;
            }
            ++n2;
        }
        classArray = cls.getInterfaces();
        n = classArray.length;
        n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            labelGenerator = this.getLabelGenerator(iCls);
            if (labelGenerator != null) {
                return labelGenerator;
            }
            ++n2;
        }
        sCls = cls.getSuperclass();
        if (sCls != null) {
            return this.getLabelGenerator(sCls);
        }
        return null;
    }

    @Override
    public Object install(Class<?> labelledClass, ILabelGenerator.Descriptor labelDescriptor) {
        return this.map.put(labelledClass, labelDescriptor);
    }

    @Override
    public Object install(Class<?> labelledClass, ILabelGenerator<?> labelGenerator) {
        return this.map.put(labelledClass, labelGenerator);
    }

    @Override
    public String labelFor(Object labelledObject) {
        ILabelGenerator.Builder labelBuilder = this.createDefaultLabelBuilder(null);
        labelBuilder.buildLabelFor(labelledObject);
        return labelBuilder.toString();
    }

    @Override
    public String labelFor(Object labelledObject, Map<ILabelGenerator.Option<?>, Object> options) {
        ILabelGenerator.Builder labelBuilder = this.createDefaultLabelBuilder(options);
        labelBuilder.buildLabelFor(labelledObject);
        return labelBuilder.toString();
    }

    @Override
    public void uninstall(Class<?> labelledClass) {
        for (Class<?> aClass : new ArrayList(this.map.keySet())) {
            if (!labelledClass.isAssignableFrom(aClass)) continue;
            this.map.remove(aClass);
        }
    }
}

