/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.InstanceSpecificationLinkHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.NamedElementHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.ui.AssociationSelectionDialog;
import org.eclipse.papyrus.uml.diagram.clazz.edit.commands.InstanceSpecificationLinkCreateCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CInstanceSpecificationLinkCreateCommand
extends InstanceSpecificationLinkCreateCommand {
    protected HashSet<Association> commonAssociations;

    public CInstanceSpecificationLinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    public boolean canExecute() {
        if (this.source != null && this.target == null) {
            InstanceSpecification instance;
            if (this.source instanceof InstanceSpecification && (instance = (InstanceSpecification)this.source).getClassifiers().size() > 0) {
                HashSet assoSource = new HashSet();
                for (Classifier classifier : instance.getClassifiers()) {
                    assoSource.addAll(classifier.getAssociations());
                }
                if (assoSource.size() > 0) {
                    return true;
                }
            }
            return false;
        }
        if (this.source != null && this.target != null) {
            if (!(this.source instanceof InstanceSpecification)) {
                return false;
            }
            if (!(this.target instanceof InstanceSpecification)) {
                return false;
            }
            if (((InstanceSpecification)this.source).getClassifiers().size() == 0 || ((InstanceSpecification)this.target).getClassifiers().size() == 0) {
                return false;
            }
            HashSet assoSource = new HashSet();
            for (Classifier classifier : ((InstanceSpecification)this.source).getClassifiers()) {
                assoSource.addAll(classifier.getAssociations());
            }
            HashSet assoTarget = new HashSet();
            for (Classifier classifier : ((InstanceSpecification)this.target).getClassifiers()) {
                assoTarget.addAll(classifier.getAssociations());
            }
            assoSource.retainAll(assoTarget);
            this.commonAssociations = new HashSet();
            this.commonAssociations.addAll(assoSource);
            return this.commonAssociations.size() > 0;
        }
        return false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Association selectedAssociation = null;
        if (((InstanceSpecification)this.source).getClassifiers().size() > 0 && ((InstanceSpecification)this.target).getClassifiers().size() > 0) {
            AssociationSelectionDialog associationSelectionDialog = new AssociationSelectionDialog(new Shell(), 8, this.commonAssociations);
            associationSelectionDialog.open();
            selectedAssociation = associationSelectionDialog.getSelectedAssociation();
            InstanceSpecification instanceSpecification = UMLFactory.eINSTANCE.createInstanceSpecification();
            this.getContainer().getPackagedElements().add((Object)instanceSpecification);
            instanceSpecification.setName(NamedElementHelper.EINSTANCE.getNewUMLElementName(instanceSpecification.getOwner(), instanceSpecification.eClass()));
            instanceSpecification.getClassifiers().add((Object)selectedAssociation);
            InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.source);
            InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.target);
            for (Property property : selectedAssociation.getMemberEnds()) {
                Slot slot = UMLFactory.eINSTANCE.createSlot();
                slot.setDefiningFeature((StructuralFeature)property);
                if (((InstanceSpecification)this.source).getClassifiers().contains((Object)property.getOwner())) {
                    ((InstanceSpecification)this.source).getSlots().add((Object)slot);
                    this.associateValue((InstanceSpecification)this.target, slot, property.getType());
                    continue;
                }
                if (((InstanceSpecification)this.target).getClassifiers().contains((Object)property.getOwner())) {
                    ((InstanceSpecification)this.target).getSlots().add((Object)slot);
                    this.associateValue((InstanceSpecification)this.source, slot, property.getType());
                    continue;
                }
                instanceSpecification.getSlots().add((Object)slot);
                if (((InstanceSpecification)this.source).getClassifiers().contains((Object)property.getType())) {
                    this.associateValue((InstanceSpecification)this.source, slot, property.getType());
                    continue;
                }
                this.associateValue((InstanceSpecification)this.target, slot, property.getType());
            }
            return CommandResult.newOKCommandResult((Object)instanceSpecification);
        }
        return CommandResult.newCancelledCommandResult();
    }

    protected InstanceValue associateValue(InstanceSpecification instanceSpecification, Slot owner, Type type) {
        InstanceValue iv = UMLFactory.eINSTANCE.createInstanceValue();
        iv.setName(NamedElementHelper.EINSTANCE.getNewUMLElementName((Element)owner, iv.eClass()));
        iv.setType(type);
        iv.setInstance(instanceSpecification);
        owner.getValues().add((Object)iv);
        return iv;
    }
}

