/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.MoveDropStrategy;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideElementsRequest;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.UMLPackage;

public class MoveInnerClassDropStrategy
extends MoveDropStrategy {
    public String getLabel() {
        return "Reparent";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.move.innerClass";
    }

    public String getDescription() {
        return "Move the selected class to the target class or package";
    }

    protected EStructuralFeature getTargetFeature(Request request, EditPart targetEditPart) {
        EObject targetSemanticElement = this.getTargetSemanticElement(targetEditPart);
        if (targetSemanticElement instanceof Class) {
            return UMLPackage.eINSTANCE.getClass_NestedClassifier();
        }
        if (targetSemanticElement instanceof Interface) {
            return UMLPackage.eINSTANCE.getInterface_NestedClassifier();
        }
        return null;
    }

    public int getPriority() {
        return 101;
    }

    protected Command getGraphicalCommand(Request request, EditPart targetEditPart) {
        DropObjectsRequest dropRequest = this.getDropObjectsRequest(request);
        if (dropRequest == null) {
            return null;
        }
        LinkedList<CreateViewRequest.ViewDescriptor> viewDescriptors = new LinkedList<CreateViewRequest.ViewDescriptor>();
        for (EObject eObject : this.getSourceEObjects((Request)dropRequest)) {
            if (!(eObject instanceof Class)) continue;
            viewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(eObject), Node.class, Integer.toString(3014), ((IGraphicalEditPart)targetEditPart).getDiagramPreferencesHint()));
        }
        if (viewDescriptors.isEmpty()) {
            return null;
        }
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        targetEditPart = this.getTargetEditPart(targetEditPart);
        Command createCommand = targetEditPart.getCommand((Request)createViewRequest);
        if (createCommand != null) {
            List result = (List)createViewRequest.getNewObject();
            dropRequest.setResult((Object)result);
            RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(result);
            Command refreshCommand = targetEditPart.getCommand((Request)refreshRequest);
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(result);
            Command arrangeCommand = targetEditPart.getCommand((Request)arrangeRequest);
            CompoundCommand cc = new CompoundCommand(createCommand.getLabel());
            cc.add(createCommand.chain(refreshCommand));
            cc.add(arrangeCommand);
            for (Object object : dropRequest.getObjects()) {
                ShowHideElementsRequest destroyViewRequest;
                EditPart editPart;
                Command destroyViewCommand;
                if (!(object instanceof EditPart) || (destroyViewCommand = (editPart = (EditPart)object).getCommand((Request)(destroyViewRequest = new ShowHideElementsRequest(editPart)))) == null) continue;
                cc.add(destroyViewCommand);
            }
            return cc;
        }
        return null;
    }

    protected EditPart getTargetEditPart(EditPart targetEditPart) {
        if (targetEditPart instanceof IGraphicalEditPart) {
            String type;
            IGraphicalEditPart target;
            EditPart primaryEditPart = this.getPrimaryEditPart(targetEditPart);
            View primaryView = ((IGraphicalEditPart)targetEditPart).getPrimaryView();
            int nestedClassSemanticHint = -1;
            switch (UMLVisualIDRegistry.getVisualID((View)primaryView)) {
                case 2008: {
                    nestedClassSemanticHint = 7019;
                    break;
                }
                case 3010: {
                    nestedClassSemanticHint = 7013;
                    break;
                }
                case 2004: {
                    nestedClassSemanticHint = 7008;
                    break;
                }
                case 3023: {
                    nestedClassSemanticHint = 7029;
                    break;
                }
                case 2002: {
                    nestedClassSemanticHint = 7004;
                    break;
                }
                case 3021: {
                    nestedClassSemanticHint = 7025;
                }
            }
            if (nestedClassSemanticHint != -1 && (target = ((IGraphicalEditPart)primaryEditPart).getChildBySemanticHint(type = UMLVisualIDRegistry.getType((int)nestedClassSemanticHint))) != null) {
                return target;
            }
        }
        return targetEditPart;
    }

    protected EditPart getPrimaryEditPart(EditPart targetEditPart) {
        EditPart currentPart = targetEditPart;
        while (currentPart != null) {
            if (currentPart instanceof IPrimaryEditPart) {
                return currentPart;
            }
            currentPart = currentPart.getParent();
        }
        return targetEditPart;
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.drop.classToClassifier";
    }

    public String getCategoryLabel() {
        return "Drop a Class on a Classifier";
    }

    public String getCategory() {
        return null;
    }
}

