/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.phrase;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class HyperlinkPhraseModifier
extends PatternBasedElement {
    private static final Pattern QUALIFIED_HREF_PATTERN = Pattern.compile("(#|([a-z]{2,6}:)).*", 2);

    protected String getPattern(int groupOffset) {
        return "\\[(?:\\s*([^\\]\\|]+)\\|)?([^\\]]+)\\]";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkPhraseModifierProcessor();
    }

    private static class HyperlinkPhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkPhraseModifierProcessor() {
        }

        public void emit() {
            String text = this.group(1);
            String linkComposite = this.group(2);
            String[] parts = linkComposite.split("\\s*\\|\\s*");
            if (parts.length != 0) {
                String tip;
                String href;
                if (text != null) {
                    text = text.trim();
                }
                if ((href = parts[0]) != null) {
                    href = href.trim();
                }
                String string = tip = parts.length > 1 ? parts[1] : null;
                if (tip != null) {
                    tip = tip.trim();
                }
                if (text == null || text.length() == 0) {
                    text = href;
                    if (text != null && text.length() > 0 && text.charAt(0) == '#') {
                        text = text.substring(1);
                    }
                    LinkAttributes attributes = new LinkAttributes();
                    attributes.setTitle(tip);
                    this.getBuilder().link((Attributes)attributes, this.toInternalHref(href), text);
                } else {
                    LinkAttributes attributes = new LinkAttributes();
                    attributes.setTitle(tip);
                    attributes.setHref(this.toInternalHref(href));
                    this.getBuilder().beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
                    this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, this.start(1), text, 0);
                    this.getBuilder().endSpan();
                }
            }
        }

        private String toInternalHref(String href) {
            if (QUALIFIED_HREF_PATTERN.matcher(href).matches()) {
                return href;
            }
            String internalLinkPattern = this.getMarkupLanguage().getInternalLinkPattern();
            if (internalLinkPattern != null) {
                return MessageFormat.format(internalLinkPattern, href);
            }
            return href;
        }
    }
}

