/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.uml.diagram.common.layout.DistributionConstants;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.common.layout.LinkRepresentationForLayoutAction;
import org.eclipse.papyrus.uml.diagram.menu.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteAction {
    private int routing = 0;
    private List<IGraphicalEditPart> selectedElements;
    private List<LinkRepresentationForLayoutAction> links;

    public RouteAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        this.selectedElements = selectedElements;
        this.routing = this.getRoutingValue(parameter);
        this.links = new ArrayList<LinkRepresentationForLayoutAction>();
        this.calculateNewPosition();
    }

    public Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        if (this.onlyConnectionEditPart(this.selectedElements) && this.routing != 0) {
            for (LinkRepresentationForLayoutAction obj : this.links) {
                Command cmd;
                if (!this.onOppositeSides(obj) || (cmd = obj.getCommand()) == UnexecutableCommand.INSTANCE) continue;
                command.add(cmd);
                SetAllBendpointRequest noBendpoints = new SetAllBendpointRequest("set_all_connection_bendpoint", new PointList(), null, null);
                command.add(obj.getRepresentedLink().getCommand((Request)noBendpoints));
            }
        }
        return command.canExecute() ? command : UnexecutableCommand.INSTANCE;
    }

    protected void calculateNewPosition() {
        for (IGraphicalEditPart current : this.selectedElements) {
            if (!(current instanceof ConnectionEditPart)) continue;
            LinkRepresentationForLayoutAction link = new LinkRepresentationForLayoutAction((ConnectionEditPart)current);
            EditPart anchorMovesOnEP = this.getEditPartForMovingAnchor((ConnectionEditPart)current);
            if (anchorMovesOnEP == null) continue;
            IFigure fig = ((GraphicalEditPart)current).getFigure();
            Assert.isTrue((boolean)(fig instanceof PolylineConnectionEx));
            PolylineConnectionEx linkFigure = (PolylineConnectionEx)fig;
            Point start = linkFigure.getStart();
            Point end = linkFigure.getEnd();
            linkFigure.translateToAbsolute((Translatable)start);
            linkFigure.translateToAbsolute((Translatable)end);
            Point movedAnchor = this.findMovingAnchor(start, end);
            if (movedAnchor == null) break;
            Point fixedAncher = movedAnchor == start ? end : start;
            Point newLocation = this.getNewLocation(fixedAncher, movedAnchor);
            link.setNewLocationFor(anchorMovesOnEP, newLocation);
            this.links.add(link);
        }
    }

    protected Point getNewLocation(Point fixedAnchor, Point movedAnchor) {
        Point delta = new Point();
        if (this.routing == 1 || this.routing == 4) {
            delta.setLocation(0, fixedAnchor.y - movedAnchor.y);
        } else if (this.routing == 8 || this.routing == 32) {
            delta.setLocation(fixedAnchor.x - movedAnchor.x, 0);
        }
        return movedAnchor.getTranslated(delta.x, delta.y);
    }

    protected EditPart getEditPartForMovingAnchor(ConnectionEditPart current) {
        EditPart source = current.getSource();
        EditPart target = current.getTarget();
        IFigure fig = current.getFigure();
        Assert.isTrue((boolean)(fig instanceof PolylineConnectionEx));
        PolylineConnectionEx linkFigure = (PolylineConnectionEx)fig;
        Point start = linkFigure.getStart();
        Point end = linkFigure.getEnd();
        linkFigure.translateToAbsolute((Translatable)start);
        linkFigure.translateToAbsolute((Translatable)end);
        Point movedAnchor = this.findMovingAnchor(start, end);
        if (movedAnchor == null) {
            return null;
        }
        int sideSource = LayoutUtils.getAnchorPosition((EditPart)source, (Point)movedAnchor);
        int sideTarget = LayoutUtils.getAnchorPosition((EditPart)target, (Point)movedAnchor);
        if (sideSource != 0) {
            return source;
        }
        if (sideTarget != 0) {
            return target;
        }
        Activator.log.debug("I can't find the EditPart on which moves the anchor");
        return null;
    }

    protected int getRoutingValue(String param) {
        if (param.equals("parameter_left")) {
            return 1;
        }
        if (param.equals("parameter_right")) {
            return 4;
        }
        if (param.equals("parameter_top")) {
            return 8;
        }
        if (param.equals("parameter_bottom")) {
            return 32;
        }
        return 0;
    }

    protected boolean onlyConnectionEditPart(List<IGraphicalEditPart> elementsToTest) {
        for (IGraphicalEditPart current : elementsToTest) {
            if (current instanceof ConnectionEditPart) continue;
            return false;
        }
        return true;
    }

    protected Point findMovingAnchor(Point source, Point target) {
        Point movingAnchor = null;
        switch (this.routing) {
            case 1: {
                if (source.x < target.x) {
                    movingAnchor = source;
                    break;
                }
                movingAnchor = target;
                break;
            }
            case 4: {
                if (source.x > target.x) {
                    movingAnchor = source;
                    break;
                }
                movingAnchor = target;
                break;
            }
            case 8: {
                if (source.y < target.y) {
                    movingAnchor = source;
                    break;
                }
                movingAnchor = target;
                break;
            }
            case 32: {
                if (source.y > target.y) {
                    movingAnchor = source;
                    break;
                }
                movingAnchor = target;
                break;
            }
        }
        if (movingAnchor == null) {
            Activator.log.debug("I can't find the moving anchor");
        }
        return movingAnchor;
    }

    protected boolean onOppositeSides(LinkRepresentationForLayoutAction link) {
        int side1 = link.getSideOnSource();
        int side2 = link.getSideOnTarget();
        return this.routing == 4 || this.routing == 1 ? DistributionConstants.verticalValuesList.contains(side1) && DistributionConstants.verticalValuesList.contains(side2) : (this.routing == 8 || this.routing == 32) && DistributionConstants.horizontalValuesList.contains(side1) && DistributionConstants.horizontalValuesList.contains(side2);
    }
}

