/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.providers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.papyrus.uml.diagram.common.providers.AbstractActionStateSourceProvider;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ArrangeHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.CopyAppearancePropertiesHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.FillColorHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.FontHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.LineColorHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.LineStyleHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.RecalculatePageBreaksHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SelectHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideCompartmentHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideContentsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ShowHideLabelsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SnapToGridHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SortFilterCompartmentItemsHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ViewGridHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ViewPageBreaksHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ViewRulersHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ZOrderHandler;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.ZoomHandler;

public class HandlerStateSourceProvider
extends AbstractActionStateSourceProvider {
    public static final String SHOW_HIDE_CONTENTS = "showHideContents";
    public static final String SHOW_HIDE_COMPARTMENTS = "showHideCompartments";
    public static final String COPY_APPEARANCE_PROPERTIES = "copyAppearanceProperties";
    public static final String GRID = "grid";
    public static final String RULERS = "rulers";
    public static final String PAGE_BREAKS = "pageBreaks";
    public static final String RECALCULATE_PAGE_BREAKS = "recalculatePageBreaks";
    public static final String SNAP_TO_GRID = "snapToGrid";
    public static final String SORT_FILTER_COMPARTMENT_ITEMS = "sortFilterCompartmentItems";
    public static final String ZOOM = "zoom";
    public static final String BRING_TO_FRONT = "bringToFront";
    public static final String SEND_TO_BACK = "sendToBack";
    public static final String BRING_FORWARD = "bringForward";
    public static final String SEND_BACKWARD = "sendBackward";
    public static final String ARRANGE_ALL = "arrangeAll";
    public static final String ARRANGE_SELECTION = "arrangeSelection";
    public static final String SELECT_ALL = "selectAll";
    public static final String SELECT_ALL_SHAPES = "selectAllShapes";
    public static final String SELECT_ALL_CONNECTORS = "selectAllConnectors";
    public static final String FONT = "font";
    public static final String FILL_COLOR = "fillColor";
    public static final String LINE_COLOR = "lineColor";
    public static final String LINE_STYLE = "lineStyle";
    public static final String LINE_STYLE_TREE = "lineStyleTree";
    public static final String SHOW_HIDE_CONNECTION_LABELS = "showHideLabels";

    public HandlerStateSourceProvider() {
        this.currentState.put(SHOW_HIDE_CONTENTS, "disabled");
        this.currentState.put(SHOW_HIDE_COMPARTMENTS, "disabled");
        this.currentState.put(COPY_APPEARANCE_PROPERTIES, "disabled");
        this.currentState.put(GRID, "disabled");
        this.currentState.put(RULERS, "disabled");
        this.currentState.put(PAGE_BREAKS, "disabled");
        this.currentState.put(RECALCULATE_PAGE_BREAKS, "disabled");
        this.currentState.put(SNAP_TO_GRID, "disabled");
        this.currentState.put(SORT_FILTER_COMPARTMENT_ITEMS, "disabled");
        this.currentState.put(ZOOM, "disabled");
        this.currentState.put(BRING_TO_FRONT, "disabled");
        this.currentState.put(SEND_TO_BACK, "disabled");
        this.currentState.put(BRING_FORWARD, "disabled");
        this.currentState.put(SEND_BACKWARD, "disabled");
        this.currentState.put(ARRANGE_ALL, "disabled");
        this.currentState.put(ARRANGE_SELECTION, "disabled");
        this.currentState.put(SELECT_ALL, "disabled");
        this.currentState.put(SELECT_ALL_SHAPES, "disabled");
        this.currentState.put(SELECT_ALL_CONNECTORS, "disabled");
        this.currentState.put(FONT, "disabled");
        this.currentState.put(FILL_COLOR, "disabled");
        this.currentState.put(LINE_COLOR, "disabled");
        this.currentState.put(LINE_STYLE, "disabled");
        this.currentState.put(LINE_STYLE_TREE, "disabled");
        this.currentState.put(SHOW_HIDE_CONNECTION_LABELS, "disabled");
    }

    public String[] getProvidedSourceNames() {
        return new String[]{SHOW_HIDE_CONTENTS, SHOW_HIDE_COMPARTMENTS, COPY_APPEARANCE_PROPERTIES, GRID, RULERS, PAGE_BREAKS, RECALCULATE_PAGE_BREAKS, SNAP_TO_GRID, ZOOM, BRING_TO_FRONT, SEND_TO_BACK, BRING_FORWARD, SEND_BACKWARD, ARRANGE_ALL, ARRANGE_SELECTION, SELECT_ALL, SELECT_ALL_CONNECTORS, SELECT_ALL_SHAPES, FONT, FILL_COLOR, LINE_COLOR, LINE_STYLE, LINE_STYLE_TREE, SHOW_HIDE_CONNECTION_LABELS};
    }

    protected void refreshActions() {
        this.refresh(SHOW_HIDE_CONTENTS, (AbstractHandler)new ShowHideContentsHandler());
        this.refresh(SHOW_HIDE_COMPARTMENTS, (AbstractHandler)new ShowHideCompartmentHandler());
        this.refresh(COPY_APPEARANCE_PROPERTIES, new CopyAppearancePropertiesHandler());
        this.refresh(GRID, new ViewGridHandler());
        this.refresh(RULERS, new ViewRulersHandler());
        this.refresh(PAGE_BREAKS, new ViewPageBreaksHandler());
        this.refresh(RECALCULATE_PAGE_BREAKS, new RecalculatePageBreaksHandler());
        this.refresh(SNAP_TO_GRID, new SnapToGridHandler());
        this.refresh(SORT_FILTER_COMPARTMENT_ITEMS, new SortFilterCompartmentItemsHandler());
        this.refresh(ZOOM, new ZoomHandler());
        this.refresh(BRING_TO_FRONT, new ZOrderHandler(BRING_TO_FRONT));
        this.refresh(SEND_TO_BACK, new ZOrderHandler(SEND_TO_BACK));
        this.refresh(BRING_FORWARD, new ZOrderHandler(BRING_FORWARD));
        this.refresh(SEND_BACKWARD, new ZOrderHandler(SEND_BACKWARD));
        this.refresh(ARRANGE_ALL, new ArrangeHandler(ARRANGE_ALL));
        this.refresh(ARRANGE_SELECTION, new ArrangeHandler(ARRANGE_SELECTION));
        this.refresh(SELECT_ALL, new SelectHandler(SELECT_ALL));
        this.refresh(SELECT_ALL_CONNECTORS, new SelectHandler(SELECT_ALL_CONNECTORS));
        this.refresh(SELECT_ALL_SHAPES, new SelectHandler(SELECT_ALL_SHAPES));
        this.refresh(FONT, new FontHandler());
        this.refresh(FILL_COLOR, new FillColorHandler());
        this.refresh(LINE_COLOR, new LineColorHandler());
        this.refresh(LINE_STYLE, new LineStyleHandler("rectilinear"));
        this.refresh(LINE_STYLE_TREE, new LineStyleHandler("tree"));
        this.refresh(SHOW_HIDE_CONNECTION_LABELS, new ShowHideLabelsHandler("show"));
    }

    protected void refresh(String key, AbstractHandler handler) {
        String newState;
        String oldState = (String)this.currentState.get(key);
        String string = newState = this.test(handler) ? "enabled" : "disabled";
        if (oldState != newState) {
            this.currentState.put(key, newState);
            this.fireSourceChanged(0, key, newState);
        }
    }

    protected boolean test(AbstractHandler handler) {
        return this.isSelectionInDiagram() && handler.isEnabled();
    }
}

